<?php

namespace App\Http\Controllers;

use App\Branch;
use App\BranchSetting;
use App\Income;
use App\IncomeHistoryRecord;
use App\Invoice;
use App\JobcardDetail;
use App\Notes;
use App\Product;
use App\RtoTax;
use App\Sale;
use App\SalePart;
use App\Service;
use App\Setting;
use App\tbl_payment_records;
use App\Updatekey;
use App\User;
use App\Vehicle;
use App\Washbay;
use Auth;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;
use Mail;
use Mpdf\Mpdf;
use Mpdf\Output\Destination;
use PDF;
use URL;

class InvoiceController extends Controller
{
    public function __construct()
    {

        $this->middleware('auth');
    }

    public function showall(Request $request)
    {
        if ($request->ajax()) {
            $query = Invoice::with('branch')->leftJoin('users as customer', 'tbl_invoices.customer_id', '=', 'customer.id')
                ->select(
                    'tbl_invoices.id',
                    'tbl_invoices.invoice_number',
                    'tbl_invoices.customer_id',
                    'tbl_invoices.type',
                    'tbl_invoices.branch_id',
                    'tbl_invoices.sales_service_id',
                    'tbl_invoices.job_card as invoice_for',
                    'tbl_invoices.grand_total',
                    'tbl_invoices.paid_amount',
                    'tbl_invoices.payment_status',
                    'tbl_invoices.date',
                    'customer.name as customer_name',
                )
                ->where('tbl_invoices.soft_delete', '=', 0)
                ->where('tbl_invoices.type', '!=', 2)->orderBy('id', 'DESC');

            // Apply filters based on user role
            if (! isAdmin(Auth::User()->role_id)) {
                if (getUsersRole(Auth::User()->role_id) == 'Customer') {
                    if (Gate::allows('invoice_owndata')) {
                        // Customer can only see their own invoices
                        $query->where('customer_id', Auth::User()->id);
                    }
                } elseif (getUsersRole(Auth::User()->role_id) == 'Employee') {
                    // Employee can see invoices assigned to them
                    $query->join('tbl_services', 'tbl_services.id', '=', 'tbl_invoices.sales_service_id')
                        ->where('tbl_services.assign_to', '=', Auth::User()->id)
                        ->where('tbl_invoices.branch_id', Auth::User()->branch_id);
                } elseif (in_array(getUsersRole(Auth::user()->role_id), ['Support Staff', 'Accountant', 'Branch Admin'])) {
                    if (Gate::allows('invoice_owndata')) {
                        // Support Staff or similar roles with restricted access
                        $query->where([
                            ['tbl_invoices.branch_id', Auth::User()->branch_id],
                            ['create_by', Auth::User()->id],
                        ]);
                    } else {
                        // Full branch access
                        $query->where('tbl_invoices.branch_id', Auth::User()->branch_id);
                    }
                }
            }
            // Search functionality
            if ($request->has('search.value')) {
                $searchValue = $request->input('search.value');
                $query->where(function ($q) use ($searchValue) {
                    $q->where('invoice_number', 'LIKE', "%{$searchValue}%")
                        ->orWhere('grand_total', 'LIKE', "%{$searchValue}%")
                        ->orWhere('tbl_invoices.job_card', 'LIKE', "%{$searchValue}%")
                        ->orWhere('date', 'LIKE', "%{$searchValue}%")
                        ->orWhere('paid_amount', 'LIKE', "%{$searchValue}%")
                        ->orWhere('customer.name', 'LIKE', "%{$searchValue}%")
                        ->orWhere('payment_status', 'LIKE', "%{$searchValue}%");
                });
            }

            $totalRecords = $query->count();

            // Ordering
            if ($request->has('order')) {
                $orderColumn = $request->input('order.0.column');
                $orderDir = $request->input('order.0.dir');
                $columns = ['id', 'invoice_number', 'customer_id', 'type', 'sales_service_id', 'grand_total', 'paid_amount', 'date', 'payment_status'];

                if (isset($columns[$orderColumn])) {
                    $query->orderBy($columns[$orderColumn], $orderDir);
                }
            }

            // Pagination
            $query->offset($request->input('start'))
                ->limit($request->input('length'));

            $invoices = $query->get();

            $data = $invoices->map(function ($invoice) {
                $classMarginEnd = getLangCode() === 'ar' ? 'me-3' : 'me-2';
                $classpaddinx = getLangCode() === 'ar' ? 'px-2' : 'px-1';
                $actionDropdown = '<div class="dropdown_toggle">
						<img src="'.asset('public/img/list/dots.png').'" 
							class="btn dropdown-toggle border-0" 
							type="button" 
							id="dropdownMenuButton1" 
							data-bs-toggle="dropdown" 
							aria-expanded="false">
						<ul class="dropdown-menu heder-dropdown-menu action_dropdown shadow py-2" 
							aria-labelledby="dropdownMenuButton1">';

                // Check user role
                if (getUserRoleFromUserTable(Auth::User()->id) == 'admin' ||
                    getUserRoleFromUserTable(Auth::User()->id) == 'supportstaff' ||
                    getUserRoleFromUserTable(Auth::User()->id) == 'accountant' ||
                    getUserRoleFromUserTable(Auth::User()->id) == 'employee' ||
                    getUserRoleFromUserTable(Auth::User()->id) == 'branch_admin') {

                    // View Invoice action
                    if (auth()->user()->can('invoice_view')) {
                        if ($invoice->type != 2) {
                            $actionDropdown .= '<li class="'.$classpaddinx.'">
									<button type="button" 
											data-bs-toggle="modal" 
											data-bs-target="#myModal-job" 
											type_id="'.$invoice->type.'" 
											serviceid="'.$invoice->sales_service_id.'" 
											job_no="'.$invoice->invoice_for.'" 
											auto_id="'.$invoice->id.'" 
											url="'.url('/jobcard/modalview').'" 
											sale_url="'.url('/sales/list/modal').'" 
											class="dropdown-item save">
										<img src="'.asset('public/img/list/Vector.png').'" class="'.$classMarginEnd.'">'.
                                    trans('message.View Invoice').
                                '</button>
								</li>';
                        } else {
                            $actionDropdown .= '<li class="'.$classpaddinx.'">
									<button type="button" 
											data-bs-toggle="modal" 
											data-bs-target="#myModal-job" 
											type_id="'.$invoice->type.'" 
											serviceid="'.$invoice->sales_service_id.'" 
											job_no="'.$invoice->invoice_for.'" 
											auto_id="'.$invoice->id.'" 
											url="'.url('/jobcard/modalview').'" 
											sale_url="'.url('/sales_part/list/modal').'" 
											class="dropdown-item save">
										<img src="'.asset('public/img/list/Vector.png').'" class="'.$classMarginEnd.'">'.
                                    trans('message.View Invoice').
                                '</button>
								</li>';
                        }
                    }

                    // Edit action
                    if (auth()->user()->can('invoice_edit')) {
                        $actionDropdown .= '<li class="'.$classpaddinx.'">
								<a href="'.url('/invoice/list/edit/'.$invoice->id).'" class="dropdown-item">
									<img src="'.asset('public/img/list/Edit.png').'" class="'.$classMarginEnd.'">'.
                                trans('message.Edit').
                            '</a>
							</li>';
                    }
                    // Payment History button
                    if (Gate::allows('invoice_edit') || Gate::allows('invoice_delete')) {
                        $actionDropdown .= '<li class="'.$classpaddinx.'">
								<button type="button" 
										data-bs-toggle="modal" 
										data-bs-target="#myModal-payment" 
										invoice_id="'.$invoice->id.'" 
										url="'.url('/invoice/payment/paymentview').'" 
										class="dropdown-item Payment">
									<img src="'.asset('public/img/list/payment.png').'" class="'.$classMarginEnd.'">'.
                                trans('message.Payment History').
                            '</button>
							</li>';

                        // Pay button if amount due
                        if ($invoice->grand_total > $invoice->paid_amount) {
                            $actionDropdown .= '<li class="'.$classpaddinx.' px-1">
									<a href="'.url('/invoice/pay/'.$invoice->id).'" class="dropdown-item">
										<img src="'.asset('public/img/list/pay.png').'" class="'.$classMarginEnd.'">'.
                                    trans('message.Pay').
                                '</a>
								</li>';
                        }
                    }

                    // WhatsApp share button
                    if (auth()->user()->can('invoice_view')) {
                        if ($invoice->type == 0) {
                            $actionDropdown .= '<li class="'.$classpaddinx.'">
									<a href="'.route('serviceSend', ['id' => $invoice->id]).'" 
									target="_blank" 
									class="dropdown-item">
										<img src="'.asset('public/img/list/WhatsApp.png').'" class="'.$classMarginEnd.'">'.
                                    trans('message.Share on WhatsApp').
                                '</a>
								</li>';
                        } elseif ($invoice->type == 1) {
                            $actionDropdown .= '<li class="'.$classpaddinx.'">
									<a href="'.route('salesSend', ['id' => $invoice->id]).'" 
									target="_blank" 
									class="dropdown-item">
										<img src="'.asset('public/img/list/WhatsApp.png').'" class="'.$classMarginEnd.'">'.
                                    trans('message.Share on WhatsApp').
                                '</a>
								</li>';
                        }
                    }

                    // Delete action
                    if (auth()->user()->can('invoice_delete')) {
                        $actionDropdown .= '<div class="dropdown-divider m-0"></div>
								<li class="'.$classpaddinx.'">
									<a url="'.url('/invoice/list/delete/'.$invoice->id).'" 
									class="dropdown-item deletedatas" 
									style="color:#FD726A">
										<img src="'.asset('public/img/list/Delete.png').'" class="'.$classMarginEnd.'">'.
                                    trans('message.Delete').
                                '</a>
								</li>';
                    }
                }
                // Customer role specific actions
                elseif (getUserRoleFromUserTable(Auth::User()->id) == 'Customer') {
                    // View Invoice action
                    if (auth()->user()->can('invoice_view')) {
                        $actionDropdown .= '<li class="'.$classpaddinx.'">
								<button type="button" 
										data-bs-toggle="modal" 
										data-bs-target="#myModal-job" 
										type_id="'.$invoice->type.'" 
										serviceid="'.$invoice->sales_service_id.'" 
										job_no="'.$invoice->invoice_for.'" 
										auto_id="'.$invoice->id.'" 
										url="'.url('/jobcard/modalview').'" 
										sale_url="'.url('/sales/list/modal').'" 
										class="dropdown-item save">
									<img src="'.asset('public/img/list/Vector.png').'" class="'.$classMarginEnd.'">'.
                                trans('message.View Invoice').
                            '</button>
							</li>';
                    }

                    // Edit action for customer
                    if (auth()->user()->can('invoice_edit')) {
                        $actionDropdown .= '<li class="'.$classpaddinx.'">
								<a href="'.url('/invoice/list/edit/'.$invoice->id).'" class="dropdown-item">
									<img src="'.asset('public/img/list/Edit.png').'" class="'.$classMarginEnd.'">'.
                                trans('message.Edit').
                            '</a>
							</li>';
                    }

                    // Payment History for customer
                    if (auth()->user()->can('invoice_view')) {
                        $actionDropdown .= '<li class="'.$classpaddinx.'">
								<button type="button" 
										data-bs-toggle="modal" 
										data-bs-target="#myModal-payment" 
										invoice_id="'.$invoice->id.'" 
										url="'.url('/invoice/payment/paymentview').'" 
										class="dropdown-item Payment">
									<img src="'.asset('public/img/list/payment.png').'" class="'.$classMarginEnd.'">'.
                                trans('message.Payment History').
                            '</button>
							</li>';

                        // Payment button
                        $amountdue = $invoice->grand_total - $invoice->paid_amount;
                        $updatekey = Updatekey::first();
                        $setting = Setting::first();
                        $paymentGateways = [];
                        if (Schema::hasTable('payment_gateways')) {
                            $paymentGateways = DB::table('payment_gateways')
                                ->where('is_active', 1)
                                ->where('gateway_name', '!=', 'stripe')
                                ->get();
                        }

                        if ($amountdue != 0 && $amountdue < 999999) {
                            if (count($paymentGateways) > 0) {
                                // If active payment gateways are available, show dropdown
                                $actionDropdown .= '<li class="dropdown py-0 px-1" style="padding-left:0px;">
														<a class="dropdown-item pay-btn" data-bs-toggle="dropdown" href="#" >
															<img src="'.asset('public/img/list/pay.png').'" class="'.$classMarginEnd.'">'.trans('message.Pay').'
														</a>
														<ul id="payDropdownMenu" class="dropdown-menu nested-dropdown" style="margin-left:-52mm !important; margin-top: -10mm; box-shadow:-2px 1px 5px #888888;">';

                                // stripe
                                $actionDropdown .= '
														<li>
															<form method="get" action="'.url('stripe/checkout').'">
																'.csrf_field().'
																<input type="hidden" name="invoice_amount" value="'.$amountdue.'">
																<input type="hidden" name="invoice_id" value="'.$invoice->id.'">
																<input type="hidden" name="invoice_no" value="'.$invoice->invoice_number.'">
																<button type="submit" class="dropdown-item">
																	<img src="'.asset('public/img/list/pay.png').'" class="me-2"> Pay with Stripe
																</button>
															</form>
														</li>';
                                foreach ($paymentGateways as $gateway) {
                                    switch (strtolower($gateway->gateway_name)) {

                                        case 'paypal':
                                            $actionDropdown .= '
												<li>
													<button class="paypalBtn dropdown-item" data-bs-toggle="modal"
														data-invoice-id="'.$invoice->id.'"
														data-amountdue="'.$amountdue.'"
														data-invoiceno="'.$invoice->invoice_number.'"
														data-bs-target="#paypalModal"
														>
														<img src="'.asset('public/img/list/pay.png').'" class="me-2"> Pay with PayPal
													</button>
												</li>';
                                            break;

                                        case 'square':
                                            $actionDropdown .= '
												<li>
													<button class="squareBtn dropdown-item" data-bs-toggle="modal"
														data-invoice-id="'.$invoice->id.'"
														data-amountdue="'.$amountdue.'"
														data-invoiceno="'.$invoice->invoice_number.'"
														data-bs-target="#squareModal"
														>
														<img src="'.asset('public/img/list/pay.png').'" class="me-2"> Pay with Square
													</button>
												</li>';
                                            break;

                                        case 'razorpay':
                                            $actionDropdown .= '
												<li>
													<button class="dropdown-item razorpayButton"
														data-invoice-id="'.$invoice->id.'"
														data-amountdue="'.$amountdue.'"
														data-invoiceno="'.$invoice->invoice_number.'"
														id="razorpayButton"
														data-payeer-name="'.Auth::user()->name.' '.Auth::user()->lastname.'"	
														data-payeer-email="'.Auth::user()->email.'"
														data-payeer-phone="'.Auth::user()->mobile_no.'"
														
													>
														<img src="'.asset('public/img/list/pay.png').'" class="me-2"> Pay with Razorpay
													</button>
												</li>';
                                            break;

                                    }
                                }

                                $actionDropdown .= '</ul></li>';
                            } else {
                                // No active gateways, default to Stripe
                                $actionDropdown .= '<li class="px-1 "><form method="get" action="'.url('stripe/checkout').'" class="medium" id="medium">
														'.csrf_field().'
														<input type="hidden" name="invoice_amount" value="'.$amountdue.'">
														<input type="hidden" name="invoice_id" value="'.$invoice->id.'">
														<input type="hidden" name="invoice_no" value="'.$invoice->invoice_number.'">
														<button type="submit" 
																class="submit2 dropdown-item" 
																data-key="'.$updatekey->publish_key.'" 
																data-email="'.getCustomerEmail($invoice->customer_id).'" 
																data-name="'.$setting->system_name.'" 
																data-description="Invoice Number - '.$invoice->invoice_number.'" 
																data-amount="'.$amountdue * 100 .'">
															<img src="'.asset('public/img/list/pay.png').'" class="'.$classMarginEnd.' ">'.
                                                        trans('message.Pay').'
														</button>
													</form></li>';
                            }
                        } elseif ($amountdue > 999999) {
                            // If the amount exceeds the limit
                            $actionDropdown .= '<li>
													<input type="submit" class="dropdown-item payWarning" value="'.trans('message.Pay Limit Exceeded').'" />
												</li>';
                        } else {
                            // If the invoice still has an outstanding balance
                            if ($invoice->grand_total > $invoice->paid_amount) {
                                $actionDropdown .= '<li class="px-1">
														<a class="dropdown-item" href="'.url('/invoice/pay/'.$invoice->id).'">
															<img src="'.asset('public/img/list/pay.png').'" class="'.$classMarginEnd.'">'.
                                                        trans('message.Pay Outstanding').'
														</a>
													</li>';
                            }
                        }

                    }

                    // Delete action for customer
                    if (auth()->user()->can('invoice_delete')) {
                        $actionDropdown .= '<div class="dropdown-divider m-0"></div>
								<li>
									<a url="'.url('/invoice/list/delete/'.$invoice->id).'" 
									class="deletedatas dropdown-item" 
									style="color:#FD726A">
										<img src="'.asset('public/img/list/Delete.png').'" class="'.$classMarginEnd.'">'.
                                    trans('message.Delete').
                                '</a>
								</li>';
                    }
                }

                $actionDropdown .= '</ul></div>';

                return [
                    'id' => $invoice->id,
                    'invoice_number' => '<a data-bs-toggle="modal" data-bs-target="#myModal-job" type_id="'.$invoice->type.'" serviceid="'.$invoice->sales_service_id.'" job_no="'.$invoice->invoice_for.'" auto_id="'.$invoice->id.'" url="'.url('/jobcard/modalview').'" sale_url="'.url('/sales/list/modal').'" class="save">'.$invoice->invoice_number.'</a>',

                    'customer_name' => '<a data-bs-toggle="modal" data-bs-target="#myModal-job" type_id="'.$invoice->type.'" serviceid="'.$invoice->sales_service_id.'" job_no="'.$invoice->invoice_for.'" auto_id="'.$invoice->id.'" url="'.url('/jobcard/modalview').'" sale_url="'.url('/sales/list/modal').'" class="save">'.getCustomerName($invoice->customer_id).'</a>',

                    'invoice_for' => $invoice->type == 2 ?
                        trans('message.Part') :
                        (getVehicleName($invoice->invoice_for) ?? $invoice->invoice_for),

                    'number_plate' => $invoice->type == 0 ?
                        (getVehicleNumberPlateFromService($invoice->sales_service_id) ?? trans('message.Not Added')) :
                        ($invoice->type == 1 ?
                            (getVehicleNumberPlateFromSale($invoice->sales_service_id) ?? trans('message.Not Added')) :
                            'N/A'),

                    'total_amount' => number_format($invoice->grand_total, 2),
                    'paid_amount' => number_format($invoice->paid_amount, 2),
                    'date' => date(getDateFormat(), strtotime($invoice->date)),

                    'status' => match ((int) $invoice->payment_status) {
                        0 => '<span style="color: rgb(255, 0, 0);">'.trans('message.UnPaid').'</span>',
                        1 => '<span style="color: rgb(255, 165, 0);">'.trans('message.Partially paid').'</span>',
                        2 => '<span style="color: rgb(0, 128, 0);">'.trans('message.Full Paid').'</span>',
                        default => '<span style="color: rgb(255, 0, 0);">'.trans('message.UnPaid').'</span>'
                    },

                    'action' => $actionDropdown,
                ];
            });

            return response()->json([
                'draw' => $request->input('draw'),
                'recordsTotal' => Invoice::where('soft_delete', 0)->count(),
                'recordsFiltered' => $totalRecords,
                'data' => $data,
            ]);
        }

        // Regular view rendering
        $currentUser = User::where([['soft_delete', 0], ['id', '=', Auth::User()->id]])->orderBy('id', 'DESC')->first();
        // $adminCurrentBranch = BranchSetting::where('id', '=', 1)->first();

        if (! isAdmin(Auth::User()->role_id)) {
            if (getUsersRole(Auth::User()->role_id) == 'Customer') {
                if (Gate::allows('invoice_owndata')) {
                    $invoice = Invoice::where([['customer_id', '=', Auth::User()->id], ['soft_delete', '=', 0]])->where('type', '!=', 2)->orderBy('id', 'DESC')->get();
                } else {
                    // $invoice = Invoice::where([['type', '!=', 2], ['soft_delete', 0]])->orderBy('id', 'DESC')->get();
                    // branch data
                    $invoice = Invoice::with('branch')
                        ->where([['type', '!=', 2], ['soft_delete', 0]])
                        ->orderBy('id', 'DESC')
                        ->get();

                    // end branch data
                }
                $updatekey = Updatekey::first();
                $logo = Setting::first();
                $branchDatas = Branch::where('soft_delete',0)->get();

            } elseif (getUsersRole(Auth::User()->role_id) == 'Employee') {
                $invoice = Service::join('tbl_invoices', 'tbl_services.id', '=', 'tbl_invoices.sales_service_id')
                    ->where('tbl_services.assign_to', '=', Auth::User()->id)
                    ->where('type', '!=', 2)
                    ->where([['tbl_invoices.soft_delete', 0], ['tbl_invoices.branch_id', $currentUser->branch_id]])
                    ->orderBy('tbl_invoices.id', 'DESC')->get();

                $updatekey = Updatekey::first();
                $logo = Setting::first();
                $branchDatas = Branch::where('soft_delete',0)->get();

            } elseif (getUsersRole(Auth::user()->role_id) == 'Support Staff' || getUsersRole(Auth::user()->role_id) == 'Accountant' || getUsersRole(Auth::user()->role_id) == 'Branch Admin') {
                if (Gate::allows('invoice_owndata')) {
                    $invoice = Invoice::where([['type', '!=', 2], ['soft_delete', 0], ['branch_id', $currentUser->branch_id], ['create_by', Auth::User()->id]])->orderBy('id', 'DESC')->get();
                } else {
                    // $invoice = Invoice::where([['type', '!=', 2], ['soft_delete', 0], ['branch_id', $currentUser->branch_id]])->orderBy('id', 'DESC')->get();
                    // branch data
                    $invoice = Invoice::with('branch')
                        ->where([['type', '!=', 2], ['soft_delete', 0], ['branch_id', $currentUser->branch_id]])
                        ->orderBy('id', 'DESC')
                        ->get();
                    // bramch data
                }
                $updatekey = Updatekey::first();
                $logo = Setting::first();
                $branchDatas = Branch::where('soft_delete',0)->get();

            }
        } else {
            // $invoice = Invoice::where([['type', '!=', 2], ['soft_delete', 0]])->orderBy('id', 'DESC')->get();
            // branch data
            $invoice = Invoice::with('branch')
                ->where([['type', '!=', 2], ['soft_delete', 0]])
                ->orderBy('id', 'DESC')
                ->get();
            $updatekey = Updatekey::first();
            $logo = Setting::first();
            $branchDatas = Branch::get();

        }
        if (Schema::hasTable('payment_gateways')) {
            $activePaymentGateways = DB::table('payment_gateways')
                ->where('is_active', 1)
                ->where('gateway_name', '!=', 'stripe')
                ->get()
                ->keyBy('gateway_name');
            foreach ($activePaymentGateways as $gateway) {
                $gateway->credentials = json_decode($gateway->credentials);
            }
        } else {
            $activePaymentGateways = [];
        }
        $setting = Setting::first();
        $currencyCode = $setting->currancy;
        $currancy = DB::table('tbl_currency_records')->find($currencyCode);

        return view('invoice.list', compact('invoice', 'updatekey', 'logo', 'branchDatas', 'activePaymentGateways', 'currancy'));
    }

    // invoice add form
    public function index(Request $request)
    {
        /* Code fore Generate Invoice number 1 to continued number */
        $last_order = DB::table('tbl_invoices')->latest()->first();

        if (! empty($last_order)) {
            $new_number = str_pad($last_order->invoice_number + 1, 8, 0, STR_PAD_LEFT);
        } else {
            $new_number = '00000001';
        }

        $code = $new_number;
        $total_rto = '';
        $id = $request->id;
        $type = $request->type;
        $characterss = '0123456789';
        $codepay = 'P'.''.substr(str_shuffle($characterss), 0, 6);

        $tax = DB::table('tbl_account_tax_rates')->where('soft_delete', '=', 0)->get()->toArray();
        $tbl_payments = DB::table('tbl_payments')->where('soft_delete', '=', 0)->get()->toArray();

        $currentUser = User::where([['soft_delete', 0], ['id', '=', Auth::User()->id]])->orderBy('id', 'DESC')->first();
        $adminCurrentBranch = BranchSetting::where('id', '=', 1)->first();
        $customer_job = null;
        $total_amount = null;
        // if (isAdmin(Auth::User()->role_id) || getUsersRole(Auth::user()->role_id) == 'Branch Admin') {
        if (isAdmin(Auth::User()->role_id)) {
            $branchDatas = Branch::get();
            $tbl_sales = DB::table('tbl_sales')->where([['id', $id], ['soft_delete', 0], ['branch_id', $adminCurrentBranch->branch_id]])->first();

            if ($type === 'Service') {

                $customer_job = DB::table('tbl_jobcard_details')->where([['service_id', $id], ['soft_delete', 0]])->first();
                // dd($customer_job);
                $job = DB::table('tbl_services')->where([['job_no', '=', $customer_job->jocard_no], ['done_status', '=', 1], ['job_no', 'like', 'J%']])->first();
                // dd($job);
                $ser_id = $job->id;
                $cus_id = $job->customer_id;
                $service_pro = DB::table('tbl_service_pros')->where([['service_id', '=', $ser_id], ['chargeable', '=', 1]])->SUM('total_price');
                // dd($service_pro);
                $othr_charges = DB::table('tbl_service_pros')->where([['service_id', '=', $ser_id], ['product_id', '=', null]])->SUM('total_price');
                $service_charge = DB::table('tbl_services')->where('id', '=', $ser_id)->first();
                $charge = $service_charge->charge;
                $wash_charge = DB::table('washbays')->where('jobcard_no', $job->job_no)->first();
                if ($wash_charge !== null) {
                    $wash_price = $wash_charge->price;
                } else {
                    $wash_price = 0;
                }
 
                $total_amount = $service_pro + $othr_charges + $charge + $wash_price;
               
            }
        } elseif (getUsersRole(Auth::user()->role_id) == 'Customer') {
            $branchDatas = Branch::where([['soft_delete',0],['id', $currentUser->branch_id]])->get();
            $tbl_sales = DB::table('tbl_sales')->where([['id', $id], ['soft_delete', 0]])->first();
            // $customer_job =DB::table('tbl_jobcard_details')->where([['service_id', $id], ['soft_delete', 0]])->first();
        } else {
            $branchDatas = Branch::where([['soft_delete',0],['id', $currentUser->branch_id]])->get();
            $tbl_sales = DB::table('tbl_sales')->where([['id', $id], ['soft_delete', 0], ['branch_id', $currentUser->branch_id]])->first();
            // $customer_job =DB::table('tbl_jobcard_details')->where([['service_id', $id], ['soft_delete', 0]])->first();
        }
        $invoice_for = 'Service';
        if (! empty($tbl_sales)) {
            $vehicleid = $tbl_sales->vehicle_id;
            $tbl_rto_taxes = DB::table('tbl_rto_taxes')->where('vehicle_id', '=', $vehicleid)->first();
            $invoice_for = 'Sales';
            if (! empty($tbl_rto_taxes)) {
                $registration_tax = $tbl_rto_taxes->registration_tax;
                $number_plate_charge = $tbl_rto_taxes->number_plate_charge;
                $muncipal_road_tax = $tbl_rto_taxes->muncipal_road_tax;
                $total_rto = $registration_tax + $number_plate_charge + $muncipal_road_tax;
            } else {
                $total_rto = 0;
            }
        }
        // DD($customer_job);
        $tbl_custom_fields = DB::table('tbl_custom_fields')->where([['form_name', '=', 'invoice'], ['always_visable', '=', 'yes'], ['soft_delete', '=', 0]])->get()->toArray();

        return view('invoice.add', compact('type', 'total_amount', 'customer_job', 'invoice_for', 'code', 'tax', 'tbl_sales', 'codepay', 'total_rto', 'tbl_payments', 'tbl_custom_fields', 'branchDatas'));
    }

    // invoice list for salespart
    public function viewSalePart()
    {
        $currentUser = User::where([['soft_delete', 0], ['id', '=', Auth::User()->id]])->orderBy('id', 'DESC')->first();
        // $adminCurrentBranch = BranchSetting::where('id', '=', 1)->first();
        $activePaymentGateways = [];
        if (! isAdmin(Auth::User()->role_id)) {
            if (getUsersRole(Auth::User()->role_id) == 'Customer') {
                $invoice = Invoice::where([['customer_id', Auth::User()->id], ['type', 2], ['soft_delete', 0]])->orderBy('id', 'DESC')->get();
                $updatekey = Updatekey::first();
                $logo = Setting::first();

                if (Schema::hasTable('payment_gateways')) {
                    $activePaymentGateways = DB::table('payment_gateways')
                        ->where('is_active', 1)
                        ->where('gateway_name', '!=', 'stripe')
                        ->get()
                        ->keyBy('gateway_name');
                    foreach ($activePaymentGateways as $gateway) {
                        $gateway->credentials = json_decode($gateway->credentials);
                    }
                } else {
                    $activePaymentGateways = [];
                }
            } elseif (getUsersRole(Auth::User()->role_id) == 'Employee') {
                $invoice = Service::join('tbl_invoices', 'tbl_services.id', '=', 'tbl_invoices.sales_service_id')
                    ->where('tbl_services.assign_to', '=', Auth::User()->id)
                    ->where('type', 2)
                    ->where([['tbl_invoices.soft_delete', 0], ['tbl_invoices.branch_id', $currentUser->branch_id]])
                    ->orderBy('tbl_invoices.id', 'DESC')->get();

                $updatekey = Updatekey::first();
                $logo = Setting::first();
            } elseif (getUsersRole(Auth::user()->role_id) == 'Support Staff' || getUsersRole(Auth::user()->role_id) == 'Accountant' || getUsersRole(Auth::user()->role_id) == 'Branch Admin') {

                $invoice = Invoice::where([['type', 2], ['soft_delete', 0], ['branch_id', $currentUser->branch_id]])->orderBy('id', 'DESC')->get();
                $updatekey = Updatekey::first();
                $logo = Setting::first();
            }
        } else {
            $invoice = Invoice::where([['type', 2], ['soft_delete', 0]])->orderBy('id', 'DESC')->get();
            $updatekey = Updatekey::first();
            $logo = Setting::first();
        }
        $setting = Setting::first();
        $currencyCode = $setting->currancy; // Default to USD if currency is not set
        $currancy = DB::table('tbl_currency_records')->find($currencyCode);

        return view('invoice.salepartlist', compact('invoice', 'updatekey', 'logo', 'activePaymentGateways', 'currancy'));
    }

    // invoice add for sale part
    public function sale_part_index(Request $request)
    {
        /* Code fore Generate Invoice number 1 to continued number */
        $last_order = DB::table('tbl_invoices')->latest()->first();
        if (! empty($last_order)) {
            $new_number = str_pad($last_order->invoice_number + 1, 8, 0, STR_PAD_LEFT);
        } else {
            $new_number = '00000001';
        }

        $id = $request->id;
        $code = $new_number;

        $characterss = '0123456789';
        $codepay = 'P'.''.substr(str_shuffle($characterss), 0, 6);

        $currentUser = User::where([['soft_delete', 0], ['id', '=', Auth::User()->id]])->orderBy('id', 'DESC')->first();
        // $adminCurrentBranch = BranchSetting::where('id', '=', 1)->first();
        if (isAdmin(Auth::User()->role_id)) {
            $branchDatas = Branch::where('soft_delete',0)->get();
            $tbl_sales = DB::table('tbl_sale_parts')->where([['id', $id]])->first();
        } elseif (getUsersRole(Auth::user()->role_id) == 'Customer') {
            $branchDatas = Branch::where('soft_delete',0)->get();
            $tbl_sales = DB::table('tbl_sale_parts')->where('id', '=', $id)->first();
        } else {
            $branchDatas = Branch::where('id', $currentUser->branch_id)->get();
            $tbl_sales = DB::table('tbl_sale_parts')->where([['id', $id], ['branch_id', $currentUser->branch_id]])->first();
        }

        $tax = DB::table('tbl_account_tax_rates')->where('soft_delete', '=', 0)->get()->toArray();
        $tbl_payments = DB::table('tbl_payments')->where('soft_delete', '=', 0)->get()->toArray();
        $tbl_saless = DB::table('tbl_sale_parts')->select(DB::raw('SUM(total_price) AS total_price,bill_no,quantity,date,product_id,price ,customer_id,id,salesmanname'))->where('bill_no', '=', $tbl_sales->bill_no)->get();
        $tbl_salessd = DB::table('tbl_sale_parts')->where('bill_no', '=', $tbl_sales->bill_no)->get();

        $tbl_custom_fields = DB::table('tbl_custom_fields')->where([['form_name', '=', 'invoice'], ['always_visable', '=', 'yes'], ['soft_delete', '=', 0]])->get()->toArray();

        // dd($tbl_salessd);
        return view('invoice.sale_part_add', compact('code', 'tax', 'tbl_sales', 'codepay', 'tbl_payments', 'tbl_saless', 'tbl_salessd', 'tbl_custom_fields', 'branchDatas'));
    }

    // get customer
    public function sales_customer(Request $request)
    {
        $type = $request->type;
        if ($type == 1) {
            $customer = DB::table('tbl_sales')->select('customer_id')->groupBy('customer_id')->get()->toArray();
        } else {
            $customer = DB::table('tbl_services')->where('done_status', '=', 1)->groupBy('customer_id')->get()->toArray();
        }
        ?>
		<?php foreach ($customer as $customers) { ?>
			<option value="<?php echo $customers->customer_id; ?>"><?php echo getCustomerName($customers->customer_id); ?></option>
		<?php
		}
    }

    // get jobcard number for which service has not generated Invoice
    public function get_jobcard_no(Request $request)
    {
        $cus_id = $request->cus_name;

        $currentUser = User::where([['soft_delete', 0], ['id', '=', Auth::User()->id]])->orderBy('id', 'DESC')->first();
        // $adminCurrentBranch = BranchSetting::where('id', '=', 1)->first();

        if (isAdmin(Auth::User()->role_id)) {
            $getJobcardNoFromServiceTbl = DB::table('tbl_services')->where([['customer_id', '=', $cus_id], ['done_status', '=', 1], ['job_no', 'like', 'J%']])->get()->toArray();
            $invoiceTblJobcardNo = DB::table('tbl_invoices')->where([['customer_id', '=', $cus_id], ['job_card', 'like', 'J%'], ['type', '=', 0]])->get()->toArray();
        } elseif (getUsersRole(Auth::user()->role_id) == 'Customer') {
            $getJobcardNoFromServiceTbl = DB::table('tbl_services')->where([['customer_id', '=', $cus_id], ['done_status', '=', 1], ['job_no', 'like', 'J%']])->get()->toArray();
            $invoiceTblJobcardNo = DB::table('tbl_invoices')->where([['customer_id', '=', $cus_id], ['job_card', 'like', 'J%'], ['type', '=', 0]])->get()->toArray();
        } else {
            $getJobcardNoFromServiceTbl = DB::table('tbl_services')->where([['customer_id', '=', $cus_id], ['done_status', '=', 1], ['job_no', 'like', 'J%'], ['branch_id', $currentUser->branch_id]])->get()->toArray();
            $invoiceTblJobcardNo = DB::table('tbl_invoices')->where([['customer_id', '=', $cus_id], ['job_card', 'like', 'J%'], ['type', '=', 0], ['branch_id', $currentUser->branch_id]])->get()->toArray();
        }

        $serviceTblJobcardArray = [];
        foreach ($getJobcardNoFromServiceTbl as $getJobcardNoFromServiceTbls) {
            $serviceTblJobcardArray[] = $getJobcardNoFromServiceTbls->job_no;
        }

        $invoiceTblJobcardArray = [];
        foreach ($invoiceTblJobcardNo as $invoiceTblJobcardNos) {
            $invoiceTblJobcardArray[] = $invoiceTblJobcardNos->job_card;
        }

        $diff_value = array_diff($serviceTblJobcardArray, $invoiceTblJobcardArray);
        $diff_normalvalue = implode(',', $diff_value);

        $getJobcardServiceTbl = DB::table('tbl_services')->whereIn('job_no', array_values($diff_value))->get()->toArray();
        ?>

		<?php if ($diff_normalvalue == '') {
		    foreach ($getJobcardServiceTbl as $getJobcardServiceTbls) { ?>
				<option class="invoice_job_number" value="<?php echo $getJobcardServiceTbls->job_no; ?>"> <?php echo $getJobcardServiceTbls->job_no; ?>
				</option>
			<?php }
		    } else {
		        foreach ($getJobcardServiceTbl as $getJobcardServiceTbls) { ?>

				<option class="invoice_job_number" value="<?php echo $getJobcardServiceTbls->job_no; ?>"> <?php echo $getJobcardServiceTbls->job_no; ?>
				</option>

		<?php }
		        } ?>

	<?php
    }

    // get service number
    public function get_service_no(Request $request)
    {
        $job_no = $request->job_no;

        $invoice_data = substr($job_no, 0, 1);
        if ($invoice_data == 'J') {
            $job = DB::table('tbl_services')->where([['job_no', '=', $job_no], ['done_status', '=', 1], ['job_no', 'like', 'J%']])->first();
            // dd($job);
            $ser_id = $job->id;
            $cus_id = $job->customer_id;
            $service_pro = DB::table('tbl_service_pros')->where([['service_id', '=', $ser_id], ['chargeable', '=', 1]])->SUM('total_price');
            $othr_charges = DB::table('tbl_service_pros')->where([['service_id', '=', $ser_id], ['product_id', '=', null]])->SUM('total_price');
            $service_charge = DB::table('tbl_services')->where('id', '=', $ser_id)->first();
            $charge = $service_charge->charge + $service_charge->mot_charge;
            $wash_charge = DB::table('washbays')->where('jobcard_no', $job->job_no)->first();
            if ($wash_charge !== null) {
                $wash_price = $wash_charge->price;
            } else {
                $wash_price = 0;
            }

            $total_amount = $service_pro + $othr_charges + $charge + $wash_price;
            if (! empty($total_amount)) {
                return [$ser_id, $total_amount, $cus_id];
            } else {
                return [$ser_id, 0, 0];
            }
        } else {
            $vehi_price = DB::table('tbl_sales')->where('vehicle_id', $job_no)->first();
            $price = $vehi_price->total_price;
            $cust = $vehi_price->customer_id;
            $id = $vehi_price->id;
            $tbl_rto_taxes = DB::table('tbl_rto_taxes')->where('vehicle_id', $job_no)->first();
            if (! empty($tbl_rto_taxes)) {
                $regi = $tbl_rto_taxes->registration_tax;
                $plate = $tbl_rto_taxes->number_plate_charge;
                $road = $tbl_rto_taxes->muncipal_road_tax;
                $total_amount = $price + $regi + $plate + $road;
            } else {
                $total_amount = $price;
            }
            if (! empty($total_amount)) {
                return [$id, $total_amount, $cust];
            } else {
                return 0;
            }
        }
    }

    // get invoice into outsanding amount
    public function get_invoice(Request $request)
    {
        $invoiceid = $request->invoiceid;
        $invoice_job = DB::table('tbl_invoices')->where('invoice_number', '=', $invoiceid)->first();
        if (! empty($invoice_job)) {
            $ser_id = $invoice_job->customer_id;
            $grand_total = $invoice_job->grand_total;
            $paid_amount = $invoice_job->paid_amount;
            $total = $grand_total - $paid_amount;

            return [$ser_id, $total];
        } else {
            return 01;
        }
    }

    // get vehicle total price
    public function get_vehicle_total(Request $request)
    {
        $vehi_id = $request->vehi_id;
        $vehi_data = DB::table('tbl_sales')->where('vehicle_id', $vehi_id)->first();
        $total_price1 = $vehi_data->total_price;
        $tbl_rto_taxes = DB::table('tbl_rto_taxes')->where('vehicle_id', '=', $vehi_id)->first();

        if (! empty($tbl_rto_taxes)) {
            $registration_tax = $tbl_rto_taxes->registration_tax;
            $number_plate_charge = $tbl_rto_taxes->number_plate_charge;
            $muncipal_road_tax = $tbl_rto_taxes->muncipal_road_tax;
            $total_rto = $registration_tax + $number_plate_charge + $muncipal_road_tax;
            $total_price = $total_price1 + $total_rto;
        } else {
            $total_price = $total_price1;
        }
        $sale_id = $vehi_data->id;

        return [$sale_id, $total_price];
    }

    // Get product
    public function get_part_total(Request $request)
    {
        $part_id = $request->part_id;
        $id = $request->id;

        $tbl_sales = DB::table('tbl_sale_parts')->where('id', '=', $id)->first();

        $tbl_salessd = DB::table('tbl_sale_parts')->where('bill_no', '=', $tbl_sales->bill_no)->get();

        // Find the item in the collection where product_id equals part_id
        $matchingItem = $tbl_salessd->first(function ($item) use ($part_id) {
            return $item->product_id == $part_id;
        });

        if ($matchingItem) {
            $product_price = $matchingItem->price;
            $total_price = $matchingItem->total_price;

            // Return the values as an array
            return [$product_price, $total_price];

            return response()->json(['product_price' => $product_price, 'total_price' => $total_price]);
        } else {
            // Handle the case where no matching item is found
            return response()->json(['error' => 'Product not found in the array'], 404);
        }
    }

    // get vehicle id for create Invoice(Which sales not generated Invoice)
    public function get_vehicle(Request $request)
    {
        $cus_id = $request->cus_name;

        $currentUser = User::where([['soft_delete', 0], ['id', '=', Auth::User()->id]])->orderBy('id', 'DESC')->first();
        $adminCurrentBranch = BranchSetting::where('id', '=', 1)->first();

        if (isAdmin(Auth::User()->role_id)) {
            $get_sales_id = DB::table('tbl_sales')->where([['customer_id', $cus_id], ['soft_delete', 0], ['branch_id', $adminCurrentBranch->branch_id]])->get()->toArray();
            $invoice_id = DB::table('tbl_invoices')->where([['customer_id', $cus_id], ['type', 1], ['soft_delete', 0], ['branch_id', $adminCurrentBranch->branch_id]])->get()->toArray();
        } elseif (getUsersRole(Auth::user()->role_id) == 'Customer') {
            $get_sales_id = DB::table('tbl_sales')->where([['customer_id', $cus_id], ['soft_delete', 0]])->get()->toArray();
            $invoice_id = DB::table('tbl_invoices')->where([['customer_id', $cus_id], ['type', 1]])->get()->toArray();
        } else {
            $get_sales_id = DB::table('tbl_sales')->where([['customer_id', $cus_id], ['soft_delete', 0], ['branch_id', $adminCurrentBranch->branch_id]])->get()->toArray();
            $invoice_id = DB::table('tbl_invoices')->where([['customer_id', $cus_id], ['type', 1], ['soft_delete', 0], ['branch_id', $adminCurrentBranch->branch_id]])->get()->toArray();
        }

        $sales_id_array = [];
        foreach ($get_sales_id as $get_sales_ids) {
            $sales_id_array[] = $get_sales_ids->id;
        }

        $salesId_inside_invoiceTbl = [];
        foreach ($invoice_id as $invoice_ids) {
            $salesId_inside_invoiceTbl[] = $invoice_ids->sales_service_id;
        }

        $diff_value = array_diff($sales_id_array, $salesId_inside_invoiceTbl);
        $diff_normalvalue = implode(',', $diff_value);
        $vehicleid = DB::table('tbl_sales')->where('id', '=', $diff_normalvalue)->get()->toArray();

        ?>
		<?php if ($diff_normalvalue == '') {
		    foreach ($vehicleid as $vehicleids) { ?>

				<option class="invoice_vehicle_name" value="<?php echo $vehicleids->vehicle_id; ?>"><?php echo getVehicleName($vehicleids->vehicle_id) ?></option>
			<?php }
		    } else {
		        foreach ($vehicleid as $vehicleids) { ?>

				<option class="invoice_vehicle_name" value="<?php echo $vehicleids->vehicle_id; ?>"><?php echo getVehicleName($vehicleids->vehicle_id) ?></option>

		<?php }
		        } ?>
	<?php
    }

    public function get_part(Request $request)
    {
        $cus_id = $request->cus_name;
        $invoice_job = DB::table('tbl_invoices')->where('customer_id', '=', $cus_id)->select('job_card')->get()->toArray();
        $invoice_jobss = [];
        foreach ($invoice_job as $invoice_jobs) {
            $invoice_jobss[] = $invoice_jobs->job_card;
        }
        $job = DB::table('tbl_sales')->where('customer_id', '=', $cus_id)->where('product_id', '!=', null)->get()->toArray();
        ?>
		<?php foreach ($job as $job) { ?>
			<option class="invoice_vehicle_name" value="<?php echo $job->product_id; ?>"><?php echo getPart($job->product_id)->name ?></option>
		<?php } ?>
<?php
    }

    // invoice store
    public function store(Request $request)
    {
        try {
            // dd($request);
            $sales_service_id = $request->jobcard_no;
            $type = $request->Invoice_type;
            // dd($type);
            $invoice_number = $request->Invoice_Number;
            $Date = $request->Date;

            if (getDateFormat() == 'm-d-Y') {
                $dates = date('Y-m-d', strtotime(str_replace('-', '/', $Date)));
            } else {
                $dates = date('Y-m-d', strtotime($Date));
            }

            $invoice = new Invoice;
            $invoice->invoice_number = $invoice_number;
            $invoice->payment_number = $request->paymentno;
            $invoice->customer_id = $request->Customer;
            $jobcard = $request->Job_card;
            $vehicle = $request->Vehicle;
            // dd($sales_service_id);
            if ($type != 2) {
                if (! empty($jobcard)) {
                    $invoice->job_card = $jobcard;
                } else {
                    $invoice->job_card = $vehicle;
                }
            } else {
                $invoice->job_card == 'NULL';
            }

            $invoice->date = $dates;
            $invoice->payment_type = $request->Payment_type;
            $invoice->payment_status = $request->Status;
            $taxs = $request->Tax;

            if (! empty($taxs)) {
                $invoice->tax_name = implode(', ', $taxs);
            }

            $invoice->total_amount = $request->Total_Amount;
            $invoice->grand_total = $request->grandtotal;
            $invoice->paid_amount = $request->paidamount;
            $invoice->amount_recevied = $request->paidamount;
            $invoice->discount = $request->Discount;
            $invoice->details = $request->Details;
            $invoice->type = $type;
            $invoice->sales_service_id = $sales_service_id;
            $invoice->branch_id = $request->branch;
            $invoice->create_by = Auth::User()->id;

            $custom = $request->custom;
            $custom_fileld_value = [];
            $custom_fileld_value_jason_array = [];
            if (! empty($custom)) {
                foreach ($custom as $key => $value) {
                    if (is_array($value)) {
                        $add_one_in = implode(',', $value);
                        $custom_fileld_value[] = ['id' => "$key", 'value' => "$add_one_in"];
                    } else {
                        $custom_fileld_value[] = ['id' => "$key", 'value' => "$value"];
                    }
                }

                $custom_fileld_value_jason_array['custom_fileld_value'] = json_encode($custom_fileld_value);

                foreach ($custom_fileld_value_jason_array as $key1 => $val1) {
                    $invoiceData = $val1;
                }
                $invoice->custom_field = $invoiceData;
            }

            $invoice->save();

            $branchDatas = Branch::where('soft_delete',0)->get();
            $customer = User::find($invoice->customer_id);
            $toEmail = $customer->email;
            // Save Notes data
            if ($invoice->save()) {
                // if ($request->notes !== null) {
                // 	saveNotes($invoice, $request->notes, $toEmail);
                // }
                if (! empty($request->notes)) {
                    // Filter notes to exclude empty ones
                    $validNotes = array_filter($request->notes, function ($note) {
                        return ! empty($note['note_text']) || (! empty($note['note_file']) && is_array($note['note_file']));
                    });

                    // Only call saveNotes if we have valid notes
                    if (! empty($validNotes)) {
                        saveNotes($invoice, $request->notes, $toEmail);
                    }
                }
            }

            $tbl_invoicess = DB::table('tbl_invoices')->orderBy('id', 'desc')->first();
            $invoiceid = $tbl_invoicess->id;

            $tbl_payment_records = new tbl_payment_records;
            $tbl_payment_records->invoices_id = $invoiceid;
            $tbl_payment_records->payment_number = $request->paymentno;
            $tbl_payment_records->amount = $request->paidamount;
            $tbl_payment_records->payment_type = $request->Payment_type;
            $tbl_payment_records->payment_date = $dates;
            $tbl_payment_records->branch_id = $request->branch;
            $tbl_payment_records->save();

            if ($type == 0) {
                $main_label = 'Service';
            } elseif ($type == 1) {
                $main_label = 'Sales';
            } else {
                $main_label = 'Sale Part';
            }

            $tbl_incomes = new Income;
            $tbl_incomes->invoice_number = $invoice_number;
            $tbl_incomes->payment_number = $request->paymentno;
            $tbl_incomes->customer_id = $request->Customer;
            $tbl_incomes->status = $request->Status;
            $tbl_incomes->payment_type = $request->Payment_type;
            $tbl_incomes->date = $dates;
            $tbl_incomes->main_label = $main_label;
            $tbl_incomes->branch_id = $request->branch;
            $tbl_incomes->save();

            $tbl_income_id = DB::table('tbl_incomes')->orderBy('id', 'DESC')->first();

            $tbl_income_history_records = new IncomeHistoryRecord;
            $tbl_income_history_records->tbl_income_id = $tbl_income_id->id;
            $tbl_income_history_records->income_amount = $request->paidamount;
            $tbl_income_history_records->income_label = $main_label;
            $tbl_income_history_records->branch_id = $request->branch;
            $tbl_income_history_records->save();

            if (! empty($type == 1)) {
                // PDF download
                if (! empty($sales_service_id)) {
                    $id = $sales_service_id;
                    $invoice_number = $invoice_number;
                } else {
                    $id = $sales_service_id;
                    $auto_id = $invoice->id;
                }

                $viewid = $id;
                $sales = DB::table('tbl_sales')->where('id', '=', $id)->first();
                $v_id = $sales->vehicle_id;
                $vehicale = DB::table('tbl_vehicles')->where('id', '=', $v_id)->first();
                if ($sales_service_id) {
                    $invioce = DB::table('tbl_invoices')->where([['sales_service_id', $id], ['invoice_number', $invoice_number]])->first();
                } else {
                    $invioce = DB::table('tbl_invoices')->where('id', $auto_id)->first();
                }
                if (! empty($invioce->tax_name)) {
                    $taxes = explode(', ', $invioce->tax_name);
                } else {
                    $taxes = '';
                }

                $rto = DB::table('tbl_rto_taxes')->where('vehicle_id', '=', $v_id)->first();
                $logo = DB::table('tbl_settings')->first();
                $branchDatas = Branch::where('soft_delete',0)->get();

                $mpdf = new Mpdf;

                // Get the HTML content from the view
                $html = view('invoice.salesinvoicepdfl', compact('viewid', 'vehicale', 'sales', 'logo', 'invioce', 'taxes', 'rto', 'branchDatas'));

                // Write HTML content to the PDF
                $mpdf->autoLangToFont = true;
                $mpdf->autoScriptToLang = true;
                $mpdf->WriteHTML($html);

                $str = '1234567890';
                $str1 = str_shuffle($str);

                $filePath = 'public/pdf/sales/'.$str1.'.pdf';
                $mpdf->Output($filePath, Destination::FILE);

                $sales = DB::table('tbl_sales')->where('id', '=', $sales_service_id)->first();

                $v_id = $sales->vehicle_id;
                $c_id = $sales->customer_id;
                $bill_no = $sales->bill_no;
                $s_date = $sales->date;
                $totalamount = $sales->total_price;
                $total_price = $sales->total_price;

                if (! empty($rto)) {
                    $rto_reg = $rto->registration_tax;
                    $rto_plate = $rto->number_plate_charge;
                    $rto_road = $rto->muncipal_road_tax;
                }
                if (! empty($rto)) {
                    $rto_charges = $rto_reg + $rto_plate + $rto_road;
                }
                if (! empty($rto)) {
                    $total_amt = $total_price + $rto_charges;
                } else {
                    $total_amt = $total_price;
                }

                $discount = ($total_amt * $invioce->discount) / 100;
                $after_dis_total = $total_amt - $discount;
                if (! empty($taxes)) {
                    $total_tax = 0;
                    $taxes_amount = 0;
                    foreach ($taxes as $tax) {
                        $taxes_per = preg_replace('/[^0-9,.]/', '', $tax);
                        $taxes_amount = ($after_dis_total * $taxes_per) / 100;
                        $total_tax += $taxes_amount;
                    }
                    $final_grand_total = $after_dis_total + $total_tax;
                } else {
                    $final_grand_total = $after_dis_total;
                }

                $vehicale = DB::table('tbl_vehicles')->where('id', '=', $v_id)->first();
                $rto = DB::table('tbl_rto_taxes')->where('vehicle_id', '=', $v_id)->first();
                $invioce = DB::table('tbl_invoices')->where('sales_service_id', $sales_service_id)->first();
                if (! empty($invioce->tax_name)) {
                    $taxes = explode(', ', $invioce->tax_name);
                } else {
                    $taxes = '';
                }
                $user = DB::table('users')->where('id', '=', $c_id)->first();
                $email = $user->email;
                $firstname = $user->name;
                $logo = DB::table('tbl_settings')->first();
                $systemname = $logo->system_name;
                $emailformats = DB::table('tbl_mail_notifications')->where('notification_for', '=', 'Sales_notification')->first();

                if ($emailformats->is_send == 0) {
                    if ($invoice->save()) {
                        $emailformat = DB::table('tbl_mail_notifications')->where('notification_for', '=', 'Sales_notification')->first();

                        $mail_format = $emailformat->notification_text;
                        $mail_subjects = $emailformat->subject;
                        $mail_send_from = $emailformat->send_from;
                        $search1 = ['{ system_name }', '{ invoice_ID }'];
                        $replace1 = [$systemname, $invoice_number];
                        $mail_sub = str_replace($search1, $replace1, $mail_subjects);
                        $search = ['{ system_name }', '{ Customer_name }', '{ amount }', '{ date }', '{ invoice }'];
                        $replace = [$systemname, $firstname, $final_grand_total, $s_date, 'invoice'];
                        $email_content = str_replace($search, $replace, $mail_format);

                        $server = $_SERVER['SERVER_NAME'];
                        if (isset($_SERVER['HTTPS'])) {
                            $protocol = ($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != 'off') ? 'https' : 'http';
                        } else {
                            $protocol = 'http';
                        }
                        // $url = URL::to('/public/pdf/sales/' . $str1 . '.pdf');
                        $url = public_path('pdf/sales/').basename($str1.'.pdf');

                        $fileatt = 'test.pdf'; // Path to the file

                        $fileatt_type = 'application/pdf'; // File Type
                        $fileatt_name = $str1.'.pdf'; // Filename that will be used for the file as the attachment
                        $email_from = $mail_send_from; // Who the email is from
                        $email_subject = $mail_sub; // The Subject of the email
                        $email_message = $email_content;

                        $email_to = $email; // Who the email is to
                        $headers = 'From: '.$email_from;

                        $file = fopen($url, 'rb');

                        $contents = file_get_contents($url); // read the remote file
                        touch('temp.pdf'); // create a local EMPTY copy
                        file_put_contents('temp.pdf', $contents);

                        $data = fread($file, filesize('temp.pdf'));
                        fclose($file);
                        $semi_rand = md5(time());
                        $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";

                        $headers = 'Content-type: text/html; charset=iso-8859-1'."\r\n";
                        $headers .= 'From:'.$mail_send_from."\r\n";
                        // 		$email_message .= "This is a multi-part message in MIME format.\n\n" .
                        // 			"--{$mime_boundary}\n" .
                        // 			"Content-Type:text/html; charset=\"iso-8859-1\"\n" .
                        // 			"Content-Transfer-Encoding: 7bit\n\n" .
                        // 			$email_message .= "\n\n";
                        // 		$data = chunk_split(base64_encode(file_get_contents('temp.pdf')));
                        // 		$email_message .= "--{$mime_boundary}\n" .
                        // 			"Content-Type: {$fileatt_type};\n" .
                        // 			" name=\"{$fileatt_name}\"\n" .
                        // 			"Content-Transfer-Encoding: base64\n\n" .
                        // 			$data .= "\n\n" .
                        // 			"--{$mime_boundary}--\n";

                        $actual_link = $_SERVER['HTTP_HOST'];
                        $startip = '0.0.0.0';
                        $endip = '255.255.255.255';
                        if (($actual_link == 'localhost' || $actual_link == 'localhost:8080') || ($actual_link >= $startip && $actual_link <= $endip)) {
                            // local format email

                            $data = [
                                'email' => $email,
                                'mail_sub1' => $mail_sub,
                                'email_content1' => $email_content,
                                'emailsend' => $mail_send_from,
                                'logo' => $logo,
                                'rto' => $rto,
                                'taxes' => $taxes,
                                'vehicale' => $vehicale,
                                'sales' => $sales,
                                'pdf' => $pdf->output(),
                                'str' => $str1.'.pdf',
                            ];

                            try {
                                $data1 = Mail::send('sales.salesmail', $data, function ($message) use ($data) {

                                    $message->from($data['emailsend'], 'noreply');
                                    $message->attachData($data['pdf'], 'salesinvoice.pdf');
                                    $message->to($data['email'])->subject($data['mail_sub1']);
                                });
                            } catch (\Exception $e) {
                                \Log::info('Failed to send mail'.$e->getMessage());
                            }

                        } else {
                            $ok = mail($email_to, $email_subject, $email_message, $headers);
                        }
                    }
                }
                // Generating free service coupons in sales

                $sales = DB::table('tbl_sales')->where('id', '=', $sales_service_id)->first();
                $salesid = $sales->id;
                $c_id = $sales->customer_id;
                $v_id = $sales->vehicle_id;
                $vehicle = DB::table('tbl_vehicles')->where('id', '=', $v_id)->first();
                $manufacturer = getVehicleBrands($vehicle->vehiclebrand_id);
                $modelname = $vehicle->modelname;

                $tbl_services = DB::table('tbl_services')->where('sales_id', '=', $salesid)->get()->toArray();
                foreach ($tbl_services as $tbl_servicess) {
                    $coupons = $tbl_servicess->job_no;
                }
                $user = DB::table('users')->where('id', '=', $c_id)->first();
                $email = $user->email;
                $firstname = $user->name;
                $logo = DB::table('tbl_settings')->first();
                $systemname = $logo->system_name;
                $emailformats = DB::table('tbl_mail_notifications')->where('notification_for', '=', 'free_service_coupons')->first();
                if ($emailformats->is_send == 0) {
                    if ($invoice->save()) {
                        $emailformat = DB::table('tbl_mail_notifications')->where('notification_for', '=', 'free_service_coupons')->first();
                        $mail_format = $emailformat->notification_text;
                        $mail_subjects = $emailformat->subject;
                        $mail_send_from = $emailformat->send_from;

                        $search1 = ['{ manufacturer }', '{ model_Number }'];
                        $replace1 = [$manufacturer, $modelname];

                        $mail_sub = str_replace($search1, $replace1, $mail_subjects);

                        $message = '<html><body>';
                        $message .= '<br/><table rules="all" style="border-color: #666;" border="1" cellpadding="10">';
                        $message .= "<tr style='background: #eee;'><td><strong>Free-service coupan</strong> </td></tr>";
                        foreach ($tbl_services as $tbl_servicess) {
                            $message .= '<tr><td>'.$tbl_servicess->job_no.'</td></tr>';
                        }
                        $message .= '</table><br/><br/>';
                        $message .= '</body></html>';

                        $search = ['{ system_name }', '{ Customer_name }', '{ manufacturer }', '{ model_Number }', '{ coupon_list }'];
                        $replace = [$systemname, $firstname, $manufacturer, $modelname, $message];

                        $email_content = str_replace($search, $replace, $mail_format);
                        $actual_link = $_SERVER['HTTP_HOST'];
                        $startip = '0.0.0.0';
                        $endip = '255.255.255.255';

                        $data = [
                            'email' => $email,
                            'mail_sub1' => $mail_sub,
                            'email_content1' => $email_content,
                            'emailsend' => $mail_send_from,
                        ];

                        if (($actual_link == 'localhost' || $actual_link == 'localhost:8080') || ($actual_link >= $startip && $actual_link <= $endip)) {
                            // local format email

                            try {
                                $data1 = Mail::send('sales.salescouponfree', $data, function ($message) use ($data) {

                                    $message->from($data['emailsend'], 'noreply');

                                    $message->to($data['email'])->subject($data['mail_sub1']);
                                });
                            } catch (\Exception $e) {
                                \Log::error('Failed to send mail'.$e->getMessage());
                            }

                        } else {
                            // live format email
                            $headers = 'Content-type: text/html; charset=iso-8859-1'."\r\n";
                            $headers .= 'From:'.$mail_send_from."\r\n";

                            $data = mail($email, $mail_sub, $email_content, $headers);
                        }
                    }
                }
            }

            // invoice for service in message
            if (! empty($type == 0)) {

                // pdf download
                $serviceid = $sales_service_id;
                // dd($serviceid);
                // dd($request->Job_card);

                $tbl_services = DB::table('tbl_services')->where('job_no', '=', $request->Job_card)->first();

                $c_id = $tbl_services->customer_id;
                $v_id = $tbl_services->vehicle_id;

                $s_id = $tbl_services->sales_id;
                $sales = DB::table('tbl_sales')->where('id', '=', $s_id)->first();

                $job = DB::table('tbl_jobcard_details')->where('service_id', '=', $serviceid)->first();
                $s_date = DB::table('tbl_sales')->where('vehicle_id', '=', $v_id)->first();

                $vehical = DB::table('tbl_vehicles')->where('id', '=', $v_id)->first();

                $customer = DB::table('users')->where('id', '=', $c_id)->first();
                $service_pro = DB::table('tbl_service_pros')->where('service_id', '=', $serviceid)
                    ->where('type', '=', 0)
                    ->where('chargeable', '=', 1)
                    ->get()->toArray();

                $service_pro2 = DB::table('tbl_service_pros')->where('service_id', '=', $serviceid)
                    ->where('type', '=', 1)->get()->toArray();

                $tbl_service_observation_points = DB::table('tbl_service_observation_points')->where('services_id', '=', $serviceid)->get();

                $service_tax = DB::table('tbl_invoices')->where('sales_service_id', '=', $serviceid)->first();
                // dd($service_tax);
                if (! empty($service_tax->tax_name)) {
                    $service_taxes = explode(', ', $service_tax->tax_name);
                } else {
                    $service_taxes = '';
                }

                $discount = $service_tax->discount;
                $logo = DB::table('tbl_settings')->first();
                $invoice_pdf = Invoice::with('branch')->where('sales_service_id', '=', $sales_service_id)->first();
                /* Get Washbay Service charge */
                $washbay_data = Washbay::where('service_id', '=', $serviceid)->first();

                $tbl_invoices = Invoice::where('sales_service_id', '=', $serviceid)->first();
                // dd($tbl_invoices);
                $mpdf = new Mpdf;

                // Get the HTML content from the view
                $html = view('invoice.serviceinvoicepdf', compact('tbl_invoices', 'serviceid', 'tbl_services', 'sales', 'logo', 'invoice_pdf', 'job', 's_date', 'vehical', 'customer', 'service_pro', 'service_pro2', 'tbl_service_observation_points', 'service_tax', 'service_taxes', 'discount', 'washbay_data', 'branchDatas'));

                // Write HTML content to the PDF
                $mpdf->autoLangToFont = true;
                $mpdf->autoScriptToLang = true;
                $mpdf->WriteHTML($html);

                $str = '1234567890';
                $str1 = str_shuffle($str);

                $filePath = 'public/pdf/service/'.$str1.'.pdf';

                $mpdf->Output($filePath, Destination::FILE);
                // End pdf

                // email format
                $tbl_services = DB::table('tbl_services')->where('job_no', '=', $request->Job_card)->first();
                // dd($sales_service_id);
                $c_id = $tbl_services->customer_id;
                $title = $tbl_services->title;
                $v_id = $tbl_services->vehicle_id;

                $s_id = $tbl_services->sales_id;
                $sales = DB::table('tbl_sales')->where('id', '=', $s_id)->first();

                $job = DB::table('tbl_jobcard_details')->where('service_id', '=', $sales_service_id)->first();
                if ($job !== null) {

                    $outdate = $job->out_date;
                } else {
                    $outdate = now();
                }
                $s_date = DB::table('tbl_sales')->where('vehicle_id', '=', $v_id)->first();

                $vehical = DB::table('tbl_vehicles')->where('id', '=', $v_id)->first();

                $customer = DB::table('users')->where('id', '=', $c_id)->first();

                $get_invoice = DB::table('tbl_invoices')->where('sales_service_id', '=', $sales_service_id)->first();
                $final_grand_total = $get_invoice->grand_total;

                // if (!empty($service_tax->tax_name)) {
                // 	$service_taxes = explode(', ', $service_tax->tax_name);
                // } else {
                // }

                // $discount = $service_tax->discount;

                // $service_pro = DB::table('tbl_service_pros')->where('service_id', '=', $sales_service_id)
                // 	->where('type', '=', 0)
                // 	->where('chargeable', '=', 1)
                // 	->get()->toArray();

                // $total1 = 0;
                // $i = 1;
                // foreach ($service_pro as $service_pros) {
                // 	$total1 += $service_pros->total_price;
                // }
                // $total2 = 0;
                // $i = 1;
                // foreach ($service_pro2 as $service_pros) {
                // 	$total2 += $service_pros->total_price;
                // }
                // $fix = $tbl_services->charge;
                // $total_amt = $total1 + $total2 + $fix;
                // $dis = $service_tax->discount;
                // $discount = ($total_amt * $dis) / 100;
                // $after_dis_total = $total_amt - $discount;
                // $all_taxes = 0;
                // $total_tax = 0;
                // if (!empty($service_taxes)) {
                // 	foreach ($service_taxes as $ser_tax) {
                // 		$taxes_to_count = preg_replace("/[^0-9,.]/", "", $ser_tax);

                // 		$all_taxes = ($after_dis_total * $taxes_to_count) / 100;

                // 		$total_tax +=  $all_taxes;
                // 	}
                // 	$final_grand_total = $after_dis_total + $total_tax;
                // } else {
                // 	$final_grand_total = $after_dis_total;
                // }

                $tbl_service_observation_points = DB::table('tbl_service_observation_points')->where('services_id', '=', $sales_service_id)->get()->toArray();

                $logo = DB::table('tbl_settings')->first();
                $systemname = $logo->system_name;
                $user = DB::table('users')->where('id', '=', $c_id)->first();
                $email = $user->email;
                $firstname = $user->name;
                $emailformats = DB::table('tbl_mail_notifications')->where('notification_for', '=', 'done_service_invoice')->first();
                if ($emailformats->is_send == 0) {
                    if ($invoice->save()) {
                        $emailformat = DB::table('tbl_mail_notifications')->where('notification_for', '=', 'done_service_invoice')->first();
                        $mail_format = $emailformat->notification_text;
                        $notification_label = $emailformat->notification_label;
                        $mail_subjects = $emailformat->subject;
                        $mail_send_from = $emailformat->send_from;

                        $search1 = ['{ jobcard_no }'];
                        $replace1 = [$jobcard];
                        $mail_sub = str_replace($search1, $replace1, $mail_subjects);
                        $currency_symbol = getCurrencySymbols();
                        // $invoice = URL::to($filePath);
                        $invoice = $invoice_pdf->invoice_number.'.pdf';
                        $search = ['{ system_name }', '{ Customer_name }', '{ service_title }', '{ service_date }', '{currency_symbol}', '{ total_amount }', '{ Invoice }'];
                        $replace = [$systemname, $firstname, $title, $outdate, $currency_symbol, $final_grand_total, $invoice];
                        $email_content = str_replace($search, $replace, $mail_format);

                        // Render Blade template with all required variables
                        $redirect_url = url('/invoice/list');
                        $systemLink = url('/');
                        $blade_view = View::make('mail.template', [
                            'notification_label' => $notification_label,
                            'email_content' => $email_content,
                            'redirect_url' => $redirect_url,
                            'system_link' => $systemLink,
                        ])->render();
                        // Send email
                        try {
                            Mail::send([], [], function ($message) use ($email, $mail_sub, $blade_view, $mail_send_from, $filePath, $invoice_pdf) {

                                $message->to($email)->subject($mail_sub);
                                $message->from($mail_send_from);
                                $message->html($blade_view, 'text/html');
                                $message->attach($filePath, [
                                    'as' => 'Invoice-'.$invoice_pdf->invoice_number.'.pdf',
                                    'mime' => 'application/pdf',
                                ]);
                            });

                        } catch (\Exception $e) {
                            Log::error('Error sending service invoice email: '.$e->getMessage());
                        }
                        $messageBody = 'Your Part sell request is successful and invoice '.$invoice_number.' is created for you.Please check emails.';
                        $receiverNumber = getMobileNoWithCode($user->id);
                        if (\Schema::hasTable('sms_settings') && View::exists('smsaddon::sms_setting')) {
                            \Illuminate\Support\Facades\Http::post(route('smsaddon.send-sms'), ['messageBody' => $messageBody, 'receiver_mobile' => $receiverNumber]);
                        }
                        // live format email

                        $server = $_SERVER['SERVER_NAME'];
                        if (isset($_SERVER['HTTPS'])) {
                            $protocol = ($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != 'off') ? 'https' : 'http';
                        } else {
                            $protocol = 'http';
                        }
                        // $url = "$protocol://$server/garage/public/pdf/service/".$str1.'.pdf';
                        $url = URL::to('/public/pdf/service/'.$str1.'.pdf');
                        $fileatt = 'test.pdf'; // Path to the file

                        $fileatt_type = 'application/pdf'; // File Type
                        $fileatt_name = $str1.'.pdf'; // Filename that will be used for the file as the attachment
                        $email_from = $mail_send_from; // Who the email is from
                        $email_subject = $mail_sub; // The Subject of the email
                        $email_message = $email_content;

                        $email_to = $email; // Who the email is to
                        /* $headers = "{$from}"; */
                        $headers = 'From: '.$email_from;

                        $file = fopen($url, 'rb');

                        $contents = file_get_contents($url); // read the remote file
                        touch('temp.pdf'); // create a local EMPTY copy
                        file_put_contents('temp.pdf', $contents);

                        $data = fread($file, filesize('temp.pdf'));
                        // $data = fread($file,19189);
                        fclose($file);
                        $semi_rand = md5(time());
                        $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";

                        $headers = 'Content-type: text/html; charset=iso-8859-1'."\r\n";
                        $headers .= 'From:'.$mail_send_from."\r\n";
                        // 		$email_message .= "This is a multi-part message in MIME format.\n\n" .
                        // 			"--{$mime_boundary}\n" .
                        // 			"Content-Type:text/html; charset=\"iso-8859-1\"\n" .
                        // 			"Content-Transfer-Encoding: 7bit\n\n" .
                        // 			$email_message .= "\n\n";
                        // 		$data = chunk_split(base64_encode(file_get_contents('temp.pdf')));
                        // 		$email_message .= "--{$mime_boundary}\n" .
                        // 			"Content-Type: {$fileatt_type};\n" .
                        // 			" name=\"{$fileatt_name}\"\n" .
                        // 			"Content-Transfer-Encoding: base64\n\n" .
                        // 			$data .= "\n\n" .
                        // 			"--{$mime_boundary}--\n";

                        /* $actual_link = $_SERVER['HTTP_HOST'];
                        $startip = '0.0.0.0';
                        $endip = '255.255.255.255';
                        if (($actual_link == 'localhost' || $actual_link == 'localhost:8080') || ($actual_link >= $startip && $actual_link <= $endip)) {
                            //local format email

                            $data = array(
                                'email' => $email,
                                'mail_sub1' => $mail_sub,
                                'emailsend' => $mail_send_from,
                                'email_content1' => $email_content,

                                'service_pro' => $service_pro,
                                'service_pro2' => $service_pro2,
                                'tbl_services' => $tbl_services,
                                'sales' => $sales,
                                'job' => $job,
                                's_date' => $s_date,
                                'vehical' => $vehical,
                                'customer' => $customer,
                                'tbl_service_observation_points' => $tbl_service_observation_points,
                                'service_tax' => $service_tax,
                                'logo' => $logo,
                                // 'pdf' => $pdf->output(),
                                'str' => $str1 . '.pdf',
                            );
                            $data1 = Mail::send('jobcard.servicedone', $data, function ($message) use ($data) {

                                $message->from($data['emailsend'], 'noreply');
                                // $message->attachData($data['pdf'], "serviceinvoice.pdf");
                                $message->to($data['email'])->subject($data['mail_sub1']);
                            });
                        } else {
                            $ok = mail($email_to, $email_subject, $email_message, $headers);
                        }
                        */
                    } else {
                        // Log the failure of invoice saving
                        Log::error('Failed to save the invoice for email.');
                    }
                }

            }
            if (! empty($type == 2)) {
                // dd("hello");
                // PDF download
                if (! empty($sales_service_id)) {
                    $id = $sales_service_id;
                    $invoice_number = $invoice_number;
                } else {
                    $id = $serviceid;
                    $auto_id = $invoice->id;
                }
                // dd($sales_service_id);
                $viewid = $id;

                $salespart = DB::table('tbl_sale_parts')->where('id', '=', $id)->first();
                $p_id = $salespart->product_id;
                $products_data = DB::table('tbl_products')->where('id', '=', $p_id)->first();

                if ($sales_service_id) {
                    $invioce = DB::table('tbl_invoices')->where([['sales_service_id', $id], ['invoice_number', $invoice_number]])->first();
                } else {
                    $invioce = DB::table('tbl_invoices')->where('id', $auto_id)->first();
                }
                if (! empty($invioce->tax_name)) {
                    $taxes = explode(', ', $invioce->tax_name);
                } else {
                    $taxes = '';
                }

                $logo = DB::table('tbl_settings')->first();

                $mpdf = new Mpdf;

                // Get the HTML content from the view
                $html = view('invoice.sales_partinvoicepdfl', compact('viewid', 'products_data', 'salespart', 'logo', 'invioce', 'taxes'));

                // Write HTML content to the PDF
                $mpdf->autoLangToFont = true;
                $mpdf->autoScriptToLang = true;
                $mpdf->WriteHTML($html);

                $str = '1234567890';
                $str1 = str_shuffle($str);

                $filePath = 'public/pdf/sales/'.$str1.'.pdf';

                $mpdf->Output($filePath, Destination::FILE);

                return redirect('/sales_part/list')->with('message', 'Invoice Created Successfully');
            }
        } catch (\Exception $e) {
            // Catch any unexpected errors and log them
            Log::error('Error in service done email process: '.$e->getMessage());
        }

        return redirect('invoice/list')->with('message', 'Invoice Created Successfully');

    }

    public function sale_part_store(Request $request)
    {
        $Date = $request->Date;
        $vehicle = $request->Vehicle;
        // dd($vehicle);

        if (getDateFormat() == 'm-d-Y') {
            $dates = date('Y-m-d', strtotime(str_replace('-', '/', $Date)));
        } else {
            $dates = date('Y-m-d', strtotime($Date));
        }

        $sales_service_id = $request->jobcard_no;
        $type = $request->Invoice_type;
        $invoice_number = $request->Invoice_Number;

        $invoice = new Invoice;
        $invoice->invoice_number = $invoice_number;
        $invoice->payment_number = $request->paymentno;
        $invoice->customer_id = $request->Customer;
        $jobcard = $request->Job_card;
        $vehicle = $request->Vehicle;
        if (! empty($jobcard)) {
            $invoice->job_card = $jobcard;
        } else {
            $invoice->job_card = $vehicle;
        }
        $invoice->date = $dates;
        $invoice->payment_type = $request->Payment_type;
        $invoice->payment_status = $request->Status;

        $Taxs = $request->Tax;
        if (! empty($Taxs)) {
            $invoice->tax_name = implode(', ', $Taxs);
        }
        $invoice->total_amount = $request->Total_Amount;
        $invoice->grand_total = $request->grandtotal;
        $invoice->paid_amount = $request->paidamount;
        $invoice->amount_recevied = $request->paidamount;
        $invoice->discount = $request->Discount;
        $invoice->details = $request->Details;
        $invoice->type = $type;
        $invoice->sales_service_id = $sales_service_id;
        $invoice->branch_id = $request->branch;
        $invoice->save();

        $customer = User::find($invoice->customer_id);
        $toEmail = $customer->email;
        // Save Notes data
        if ($invoice->save()) {
            // if ($request->notes !== null) {
            // 	saveNotes($invoice, $request->notes, $toEmail);
            // }
            if (! empty($request->notes)) {
                // Filter notes to exclude empty ones
                $validNotes = array_filter($request->notes, function ($note) {
                    return ! empty($note['note_text']) || (! empty($note['note_file']) && is_array($note['note_file']));
                });

                // Only call saveNotes if we have valid notes
                if (! empty($validNotes)) {
                    saveNotes($invoice, $request->notes, $toEmail);
                }
            }
        }

        $tbl_invoicess = DB::table('tbl_invoices')->orderBy('id', 'desc')->first();
        $invoiceid = $tbl_invoicess->id;

        $tbl_payment_records = new tbl_payment_records;
        $tbl_payment_records->invoices_id = $invoiceid;
        $tbl_payment_records->payment_number = $request->paymentno;
        $tbl_payment_records->amount = $request->paidamount;
        $tbl_payment_records->payment_type = $request->Payment_type;
        $tbl_payment_records->payment_date = $dates;
        $tbl_payment_records->branch_id = $request->branch;
        $tbl_payment_records->save();

        if ($type == 0) {
            $main_label = 'Service';
        } elseif ($type == 1) {
            $main_label = 'Sales';
        } else {
            $main_label = 'Sale Part';
        }

        $tbl_incomes = new Income;
        $tbl_incomes->invoice_number = $invoice_number;
        $tbl_incomes->payment_number = $request->paymentno;
        $tbl_incomes->customer_id = $request->Customer;
        $tbl_incomes->status = $request->Status;
        $tbl_incomes->payment_type = $request->Payment_type;
        $tbl_incomes->date = $dates;
        $tbl_incomes->main_label = $main_label;
        $tbl_incomes->branch_id = $request->branch;
        $tbl_incomes->save();

        $tbl_income_id = DB::table('tbl_incomes')->orderBy('id', 'DESC')->first();

        $tbl_income_history_records = new IncomeHistoryRecord;
        $tbl_income_history_records->tbl_income_id = $tbl_income_id->id;
        $tbl_income_history_records->income_amount = $request->paidamount;
        $tbl_income_history_records->income_label = $main_label;
        $tbl_income_history_records->branch_id = $request->branch;
        $tbl_income_history_records->save();

        if (! empty($type == 2)) {
            // PDF download
            if (! empty($sales_service_id)) {
                $id = $sales_service_id;
                $invoice_number = $invoice_number;
            } else {
                $id = $serviceid;
                $auto_id = $invoice->id;
            }

            $viewid = $id;
            $salespart = DB::table('tbl_sale_parts')->where('id', '=', $id)->first();
            $p_id = $salespart->product_id;
            $products_data = DB::table('tbl_products')->where('id', '=', $p_id)->first();

            if ($sales_service_id) {
                $invioce = Invoice::with('notes')->where([['sales_service_id', $sales_service_id], ['invoice_number', $invoice_number]])->first();
            } else {
                $invioce = Invoice::with('notes')->where('id', $auto_id)->first();
            }
            if (! empty($invioce->tax_name)) {
                $taxes = explode(', ', $invioce->tax_name);
            } else {
                $taxes = '';
            }
            $saless = SalePart::where('bill_no', '=', $salespart->bill_no)->get();
            $salesp = SalePart::select(DB::raw('SUM(total_price) AS total_price,bill_no,quantity,date,product_id,price ,customer_id,id,salesmanname'))->where('bill_no', '=', $salespart->bill_no)->get();
            $salesps = SalePart::select(DB::raw('SUM(total_price) AS total_price,bill_no,quantity,date,product_id,price ,customer_id,id,salesmanname'))->where('bill_no', '=', $salespart->bill_no)->first();
            // Custom Field  Data
            $tbl_custom_fields_salepart = DB::table('tbl_custom_fields')->where([['form_name', '=', 'salepart'], ['always_visable', '=', 'yes']])->get()->toArray();

            // Custom Field Data of User Table (For Customer Module)
            $tbl_custom_fields_customers = DB::table('tbl_custom_fields')->where([['form_name', '=', 'customer'], ['always_visable', '=', 'yes'], ['soft_delete', '=', 0]])->get()->toArray();

            $logo = DB::table('tbl_settings')->first();

            $mpdf = new Mpdf;

            // Get the HTML content from the view
            $html = view('invoice.sales_partinvoicepdfl', compact('salesp', 'salesps', 'saless', 'viewid', 'products_data', 'salespart', 'logo', 'invioce', 'taxes', 'tbl_custom_fields_salepart', 'tbl_custom_fields_customers'));

            // Write HTML content to the PDF
            $mpdf->autoLangToFont = true;
            $mpdf->autoScriptToLang = true;
            $mpdf->WriteHTML($html);

            $str = '1234567890';
            $str1 = str_shuffle($str);

            $filePath = 'public/pdf/sales/'.$str1.'.pdf';

            $mpdf->Output($filePath, Destination::FILE);
            // Sales Part invoice mail send
            $systemname = $logo->system_name;
            $customer = User::find($invoice->customer_id);
            $email = $customer->email ?? 'test123@gmail.com';
            $firstname = $customer->name;
            $emailformats = DB::table('tbl_mail_notifications')->where('notification_for', '=', 'done_partsell_invoice')->first();
            if ($emailformats->is_send == 0) {
                if ($invoice->save()) {
                    $emailformat = DB::table('tbl_mail_notifications')->where('notification_for', '=', 'done_partsell_invoice')->first();
                    $mail_format = $emailformat->notification_text;
                    $notification_label = $emailformat->notification_label;
                    $mail_subjects = $emailformat->subject;
                    $mail_send_from = $emailformat->send_from;

                    $search1 = ['{ invoice_number }'];
                    $replace1 = [$invoice_number];
                    $mail_sub = str_replace($search1, $replace1, $mail_subjects);
                    $currency_symbol = getCurrencySymbols();
                    $final_grand_total = $invioce->grand_total;
                    // $invoice = URL::to($filePath);
                    $invoice = $invoice_number.'.pdf';
                    $search = ['{ system_name }', '{ Customer_name }', '{ invoice_date }', '{currency_symbol}', '{ total_amount }', '{ Invoice }'];
                    $replace = [$systemname, $firstname, $dates, $currency_symbol, $final_grand_total, $invoice];
                    $email_content = str_replace($search, $replace, $mail_format);

                    // Render Blade template with all required variables
                    $redirect_url = url('/sales_part/list');
                    $systemLink = url('/');
                    $blade_view = View::make('mail.template', [
                        'notification_label' => $notification_label,
                        'email_content' => $email_content,
                        'redirect_url' => $redirect_url,
                        'system_link' => $systemLink,
                    ])->render();
                    // Send email
                    try {
                        Mail::send([], [], function ($message) use ($email, $mail_sub, $blade_view, $mail_send_from, $filePath, $invoice_number) {

                            $message->to($email)->subject($mail_sub);
                            $message->from($mail_send_from);
                            $message->html($blade_view, 'text/html');
                            $message->attach($filePath, [
                                'as' => 'Invoice-'.$invoice_number.'.pdf',
                                'mime' => 'application/pdf',
                            ]);
                        });

                    } catch (\Exception $e) {
                        Log::error('Error sending part sell invoice email: '.$e->getMessage());
                    }
                } else {
                    // Log the failure of invoice saving
                    Log::error('Failed to save the invoice for email.');
                }
                $messageBody = 'Your Service has been completed successfully.Your invoice '.$invoice_number.' is created for you and Total Amount is '.getCurrencySymbols().$final_grand_total.'.Please check emails.';
                $receiverNumber = getMobileNoWithCode($customer->id);
                if (\Schema::hasTable('sms_settings') && View::exists('smsaddon::sms_setting')) {
                    \Illuminate\Support\Facades\Http::post(route('smsaddon.send-sms'), ['messageBody' => $messageBody, 'receiver_mobile' => $receiverNumber]);
                }
            }

            // End sales part invoice email sending
            return redirect('/sales_part/list')->with('message', 'Invoice Created Successfully');
        }
    }

    // invoice pay
    public function pay(Request $request)
    {
        $id = $request->id;
        $characters = '0123456789';
        $code = 'P'.''.substr(str_shuffle($characters), 0, 6);
        $tbl_invoices = DB::table('tbl_invoices')->where('id', '=', $id)->first();
        $total = $tbl_invoices->grand_total;
        $paid_amount = $tbl_invoices->paid_amount;
        $dueamount = $total - $paid_amount;

        $tbl_payments = DB::table('tbl_payments')->where('soft_delete', '=', 0)->get()->toArray();

        return view('invoice/pay', compact('tbl_invoices', 'code', 'dueamount', 'tbl_payments'));
    }

    // invoice pay update
    public function payupdate(Request $request, $id)
    {
        $currentUser = User::where([['soft_delete', 0], ['id', '=', Auth::User()->id]])->orderBy('id', 'DESC')->first();
        $adminCurrentBranch = BranchSetting::where('id', '=', 1)->first();
        if (isAdmin(Auth::User()->role_id)) {
            $branchDatas = Branch::get();
        } elseif (getUsersRole(Auth::user()->role_id) == 'Customer') {
            $branchDatas = '';
        } else {
            $branchDatas = Branch::where('id', $currentUser->branch_id)->first();
        }

        $Date = $request->Date;
        if (getDateFormat() == 'm-d-Y') {
            $paymentdate = date('Y-m-d', strtotime(str_replace('-', '/', $Date)));
        } else {
            $paymentdate = date('Y-m-d', strtotime($Date));
        }

        $tbl_payment_records = new tbl_payment_records;
        $tbl_payment_records->invoices_id = $id;
        $tbl_payment_records->amount = $request->receiveamount;
        $tbl_payment_records->payment_type = $request->Payment_type;
        $tbl_payment_records->payment_date = $paymentdate;
        $tbl_payment_records->note = $request->note;
        $tbl_payment_records->payment_number = $request->paymentno;
        if ($branchDatas !== '') {
            // $tbl_payment_records->branch_id = $branchDatas->id;
        }
        $tbl_payment_records->save();

        $tbl_invoices = DB::table('tbl_invoices')->where('id', '=', $id)->first();
        $invoice_number = $tbl_invoices->invoice_number;
        $customer_id = $tbl_invoices->customer_id;
        $paid_amount = $tbl_invoices->paid_amount;
        $grandtotal = $tbl_invoices->grand_total;
        $amount = $request->receiveamount;
        $total = $paid_amount + $amount;

        $tblin = Invoice::find($id);
        $tblin->paid_amount = $total;
        $tblin->amount_recevied = $total;
        $tblin->payment_type = $request->Payment_type;
        if ($grandtotal == $total) {
            $status = 2;
            $tblin->payment_status = $status;
        } elseif ($grandtotal > $total && $total > 0) {
            $status = 1;
            $tblin->payment_status = $status;
        } elseif ($total == 0) {
            $status = 0;
            $tblin->payment_status = $status;
        }
        $tblin->save();

        if ($tbl_invoices->type == 0) {
            $main_label = 'Service';
        } elseif ($tbl_invoices->type == 1) {
            $main_label = 'Sales';
        } else {
            $main_label = '';
        }
        $tbl_incomes = new Income;
        $tbl_incomes->invoice_number = $invoice_number;
        $tbl_incomes->payment_number = $request->paymentno;
        $tbl_incomes->customer_id = $customer_id;
        // $tbl_incomes->status = $status;
        $tbl_incomes->payment_type = $request->Payment_type;
        $tbl_incomes->date = $paymentdate;
        $tbl_incomes->main_label = $main_label;
        if ($branchDatas !== '') {
            // $tbl_incomes->branch_id = $branchDatas->id;
        }
        $tbl_incomes->save();

        $tbl_income_id = DB::table('tbl_incomes')->orderBy('id', 'DESC')->first();

        $tbl_income_history_records = new IncomeHistoryRecord;
        $tbl_income_history_records->tbl_income_id = $tbl_income_id->id;
        $tbl_income_history_records->income_amount = $amount;
        $tbl_income_history_records->income_label = $main_label;
        if ($branchDatas !== '') {
            // $tbl_income_history_records->branch_id = $branchDatas->id;
        }
        $tbl_income_history_records->save();

        return redirect('/invoice/list')->with('message', 'Payment Added Successfully');
    }

    // invoice edit
    public function edit($id)
    {
        $invoice_edit = Invoice::with('notes')->find($id);
        $currentUser = User::where([['soft_delete', 0], ['id', '=', Auth::User()->id]])->orderBy('id', 'DESC')->first();
        // $adminCurrentBranch = BranchSetting::where('id', '=', 1)->first();
        if (isAdmin(Auth::User()->role_id)) {
            $branchDatas = Branch::get();
            // $invoice_edit = DB::table('tbl_invoices')->where([['id', $id], ['soft_delete', 0]])->first();
        } elseif (getUsersRole(Auth::user()->role_id) == 'Customer') {
            $branchDatas = Branch::where('id', $currentUser->branch_id)->get();
            // $invoice_edit = DB::table('tbl_invoices')->where('id', '=', $id)->first();
        } else {
            $branchDatas = Branch::where('id', $currentUser->branch_id)->get();
            // $invoice_edit = DB::table('tbl_invoices')->where([['id', $id], ['soft_delete', 0], ['branch_id', $currentUser->branch_id]])->first();
        }

        $type = $invoice_edit->type;
        if ($type == 1) {
            $customer = DB::table('tbl_sales')->select('customer_id')->groupBy('customer_id')->get()->toArray();
        } else {
            $customer = DB::table('tbl_services')->where('done_status', '=', 1)->groupBy('customer_id')->get()->toArray();
        }
        $total = $invoice_edit->grand_total;
        $paid_amount = $invoice_edit->paid_amount;
        $dueamount = $total - $paid_amount;

        $tax = DB::table('tbl_account_tax_rates')->where('soft_delete', '=', 0)->get()->toArray();
        $tbl_payments = DB::table('tbl_payments')->where('soft_delete', '=', 0)->get()->toArray();

        // Define $edit_tax before the conditional block
        $edit_tax = [];

        // Only populate $edit_tax if $invoice_edit is not null
        if ($invoice_edit) {
            $edit_tax = explode(', ', $invoice_edit->tax_name);
        }
        // Custom Field Data of Invoice Table
        $tbl_custom_fields = DB::table('tbl_custom_fields')->where([['form_name', '=', 'invoice'], ['always_visable', '=', 'yes'], ['soft_delete', '=', 0]])->get()->toArray();

        // dd($invoice_edit->payment_type);
        // dd($invoice_edit->tax);
        return view('invoice/edit', compact('edit_tax', 'invoice_edit', 'customer', 'tax', 'dueamount', 'tbl_payments', 'tbl_custom_fields', 'branchDatas'));
    }

    // invoice update
    public function update(Request $request, $id)
    {
        $tbl_invoices = DB::table('tbl_invoices')->where('id', '=', $id)->first();
        // dd($tbl_invoices);
        $paid_amount = $tbl_invoices->paid_amount;
        $invoice_number = $tbl_invoices->invoice_number;
        $payment_number = $tbl_invoices->payment_number;
        $type = $tbl_invoices->type;
        $amount_recevied = 0;
        $amount_recevied = (float) str_replace(',', '', $tbl_invoices->amount_recevied);
        $paidamount = (float) str_replace(',', '', $request->paidamount);

        // $branchDatas = Branch::get();
        // dd($branchDatas);

        if ($amount_recevied > $paidamount) {
            $amount = $amount_recevied - $paidamount;
            $paid_amount1 = $paid_amount - $amount;
        }
        if ($amount_recevied < $paidamount) {
            $amount = $paidamount - $amount_recevied;
            $paid_amount1 = $paid_amount + $amount;
        }
        if ($amount_recevied == $paidamount) {
            $paid_amount1 = $paid_amount;
        }

        $Date = $request->Date;
        if (getDateFormat() == 'm-d-Y') {
            $dates = date('Y-m-d', strtotime(str_replace('-', '/', $Date)));
        } else {
            $dates = date('Y-m-d', strtotime($Date));
        }
        $invoice = Invoice::find($id);

        $invoice->invoice_number = $request->Invoice_Number;
        $invoice->date = $dates;
        $invoice->payment_type = $request->Payment_type;
        $invoice->payment_status = $request->Status;

        $taxs = $request->Tax;
        if (! empty($taxs)) {
            $invoice->tax_name = implode(', ', $taxs);
        } else {
            $invoice->tax_name = '';
        }
        $invoice->total_amount = str_replace(',', '', $request->Total_Amount);
        $invoice->grand_total = str_replace(',', '', $request->grandtotal);
        $invoice->discount = $request->Discount;
        $invoice->amount_recevied = $request->paidamount;
        $invoice->paid_amount = $paid_amount1;
        $invoice->details = $request->Details;
        $invoice->sales_service_id = $tbl_invoices->sales_service_id;
        $invoice->branch_id = $request->branch;
        // $invoice->address = $request->branch;

        // Custom Field Data for Invoice table
        $custom = $request->custom;
        $custom_fileld_value = [];
        $custom_fileld_value_jason_array = [];
        if (! empty($custom)) {
            foreach ($custom as $key => $value) {
                if (is_array($value)) {
                    $add_one_in = implode(',', $value);
                    $custom_fileld_value[] = ['id' => "$key", 'value' => "$add_one_in"];
                } else {
                    $custom_fileld_value[] = ['id' => "$key", 'value' => "$value"];
                }
            }

            $custom_fileld_value_jason_array['custom_fileld_value'] = json_encode($custom_fileld_value);
            foreach ($custom_fileld_value_jason_array as $key1 => $val1) {
                $invoiceData = $val1;
            }
            $invoice->custom_field = $invoiceData;
        }

        $invoice->save();

        // $delete = Notes::where('entity_id', '=', $id)->delete();
        $customer = User::find($invoice->customer_id);
        $toEmail = $customer->email;
        // Save Notes data
        if ($invoice->save()) {
            // if ($request->notes !== null) {
            // 	saveNotes($invoice, $request->notes, $toEmail);
            // }
            if (! empty($request->notes)) {
                // Filter notes to exclude empty ones
                $validNotes = array_filter($request->notes, function ($note) {
                    return ! empty($note['note_text']) || (! empty($note['note_file']) && is_array($note['note_file']));
                });

                // Only call saveNotes if we have valid notes
                if (! empty($validNotes)) {
                    saveNotes($invoice, $request->notes, $toEmail);
                }
            }
        }
        return redirect('invoice/list')->with('message', 'Invoice Updated Successfully');
    }

    // invoice paymentview
    public function paymentview(Request $request)
    {
        $invoice_id = $request->invoice_id;
        $tbl_invoices = DB::table('tbl_invoices')->where('id', '=', $invoice_id)->first();
        $tbl_payment_records = DB::table('tbl_payment_records')->where('invoices_id', '=', $invoice_id)->get()->toArray();
        $html = view('invoice.paymentview')->with(compact('tbl_invoices', 'tbl_payment_records'))->render();

        return response()->json(['success' => true, 'html' => $html]);
    }

    // invoice delete
    public function destroy($id)
    {
        $tbl_payment_records = DB::table('tbl_payment_records')->where('invoices_id', '=', $id)->update(['soft_delete' => 1]);

        $tbl_invoices = DB::table('tbl_invoices')->where('id', '=', $id)->first();
        $invoice_no = $tbl_invoices->invoice_number;
        $incomes_id = DB::table('tbl_incomes')->where('invoice_number', '=', $invoice_no)->first();

        if (! empty($incomes_id)) {
            $incomeid = $incomes_id->id;

            $tbl_incomes = DB::table('tbl_incomes')->where('invoice_number', '=', $invoice_no)->update(['soft_delete' => 1]);

            $listOfIncomeDatas = DB::table('tbl_incomes')->where('invoice_number', '=', $invoice_no)->get()->toArray();
            $listOfIncomeIds = [];

            foreach ($listOfIncomeDatas as $listOfIncomeData) {
                $listOfIncomeIds[] = $listOfIncomeData->id;
                $tbl_incomes = DB::table('tbl_income_history_records')->where('tbl_income_id', '=', $listOfIncomeData->id)->update(['soft_delete' => 1]);
            }
        }

        Invoice::where('id', '=', $id)->update(['soft_delete' => 1]);

        return redirect('/invoice/list')->with('message', 'Invoice Deleted Successfully');
    }

    public function destoryMultiple(Request $request)
    {
        $ids = $request->input('ids');
        if (empty($ids)) {
            return response()->json(['message' => 'No records selected for deletion.'], 400);
        }
        foreach ($ids as $id) {
            $this->destroy($id);
        }

        return response()->json(['message' => 'Successfully deleted selected purchase records']);
    }

    // Service pdf
    public function servicepdf($id, Request $request)
    {
        $tbl_invoices = Invoice::with('notes')->find($id);
        $serviceid = $tbl_invoices->job_card;
        $tbl_services = Service::where('job_no', '=', $serviceid)->first();
        $c_id = $tbl_invoices->customer_id;
        $v_id = $tbl_invoices->vehicle_id;
        $s_id = $tbl_invoices->sales_id;
        $sales = Sale::where('id', '=', $s_id)->first();
        $job = JobcardDetail::where('service_id', '=', $tbl_services->id)->first();
        $s_date = Sale::where('vehicle_id', '=', $v_id)->first();
        $vehical = Vehicle::where('id', '=', $v_id)->first();
        $customer = User::where('id', '=', $c_id)->first();

        $service_pro = DB::table('tbl_service_pros')->where('service_id', '=', $tbl_services->id)
            ->where('type', '=', 0)
            ->where('chargeable', '=', 1)
            ->get()->toArray();

        $service_pro2 = DB::table('tbl_service_pros')->where('service_id', '=', $tbl_services->id)
            ->where('type', '=', 1)->get()->toArray();

        $tbl_service_observation_points = DB::table('tbl_service_observation_points')->where('services_id', '=', $serviceid)->get();

        $service_tax = Invoice::where('job_card', '=', $serviceid)->first();
        if (! empty($service_tax->tax_name)) {
            $service_taxes = explode(', ', $service_tax->tax_name);
        } else {
            $service_taxes = '';
        }

        $discount = '';
        if ($service_tax !== null) {

            $discount = $service_tax->discount;
        }
        $logo = Setting::first();
        $invoice_pdf = Invoice::with('branch')->where('id', $id)->first();
      
        /* Get Washbay Service charge */
        $washbay_data = Washbay::where('service_id', '=', $tbl_services->id)->first();

        // Custom Field  Data of Invoice Module
        $tbl_custom_fields_invoice = DB::table('tbl_custom_fields')->where([['form_name', '=', 'invoice'], ['always_visable', '=', 'yes']])->get()->toArray();

        // Custom Field  Data of Service Module
        $tbl_custom_fields_service = DB::table('tbl_custom_fields')->where([['form_name', '=', 'service'], ['always_visable', '=', 'yes']])->get()->toArray();

        // Custom Field Data of User Table (For Customer Module)
        $tbl_custom_fields_customers = DB::table('tbl_custom_fields')->where([['form_name', '=', 'customer'], ['always_visable', '=', 'yes'], ['soft_delete', '=', 0]])->get()->toArray();
        // dd("hello");

        $mpdf = new Mpdf;

        // Get the HTML content from the view
        $html = view('invoice.serviceinvoicepdf', compact('tbl_invoices', 'serviceid', 'tbl_services', 'sales', 'logo', 'invoice_pdf', 'job', 's_date', 'vehical', 'customer', 'service_pro', 'service_pro2', 'tbl_service_observation_points', 'service_tax', 'service_taxes', 'discount', 'tbl_custom_fields_invoice', 'tbl_custom_fields_service', 'tbl_custom_fields_customers', 'washbay_data'));

        // Write HTML content to the PDF
        $mpdf->autoLangToFont = true;
        $mpdf->autoScriptToLang = true;
        $mpdf->WriteHTML($html);

        $filename = 'INVOICE-'.$tbl_invoices->invoice_number.'.pdf';

        $filePath = public_path('pdf/service/').$filename;

        $mpdf->Output($filePath, Destination::FILE);
        // dd($tbl_custom_fields_invoice);

        // Check if page_action is set to 'mobile_app'
        if ($request->input('page_action') === 'mobile_app') {
            $filePath = 'public/pdf/service/'.$filename;
            $invoice = URL::to($filePath);

            return redirect($invoice);
        } else {
            return response()->download($filePath, $filename);
        }
    }

    // Sales pdf
    public function salespdf($id, Request $request)
    {
        $invioces = Invoice::where('id', '=', $id)->first();
        $sales_service_id = $invioces->sales_service_id;
        $invoice_number = $invioces->invoice_number;

        if (! empty($sales_service_id)) {
            $id1 = $sales_service_id;
            $invoice_number = $invoice_number;
        } else {
            $id = $serviceid;
            $auto_id = $invoice->id;
        }

        $viewid = $id;
        $sales = Sale::where('id', '=', $id1)->first();
        $v_id = $sales->vehicle_id;
        $vehicale = Vehicle::where('id', '=', $v_id)->first();
        if ($sales_service_id) {
            $invioce = Invoice::where([['sales_service_id', $id1], ['invoice_number', $invoice_number]])->first();
        } else {
            $invioce = Invoice::where('id', $id)->first();
        }
        if (! empty($invioce->tax_name)) {
            $taxes = explode(', ', $invioce->tax_name);
        } else {
            $taxes = '';
        }

        $rto = RtoTax::where('vehicle_id', '=', $v_id)->first();
        $logo = Setting::first();

        // Custom Field Data of Sales Table
        $tbl_custom_fields_sales = DB::table('tbl_custom_fields')->where([['form_name', '=', 'sales'], ['always_visable', '=', 'yes']])->get()->toArray();

        // Custom Field Data of Invoice Table
        $tbl_custom_fields_invoice = DB::table('tbl_custom_fields')->where([['form_name', '=', 'invoice'], ['always_visable', '=', 'yes']])->get()->toArray();

        // Custom Field Data of User Table (For Customer Module)
        $tbl_custom_fields_customers = DB::table('tbl_custom_fields')->where([['form_name', '=', 'customer'], ['always_visable', '=', 'yes'], ['soft_delete', '=', 0]])->get()->toArray();

        $mpdf = new Mpdf;

        // Get the HTML content from the view
        $html = view('invoice.salesinvoicepdfl', compact('viewid', 'vehicale', 'sales', 'logo', 'invioce', 'taxes', 'rto', 'tbl_custom_fields_sales', 'tbl_custom_fields_invoice', 'tbl_custom_fields_customers'));

        // Write HTML content to the PDF
        $mpdf->autoLangToFont = true;
        $mpdf->autoScriptToLang = true;
        $mpdf->WriteHTML($html);

        $filename = 'INVOICE-'.$invioces->invoice_number.'.pdf';

        $filePath = public_path('pdf/sales/').$filename;

        $mpdf->Output($filePath, Destination::FILE);

        // Check if page_action is set to 'mobile_app'
        if ($request->input('page_action') === 'mobile_app') {
            $filePath = 'public/pdf/sales/'.$filename;
            $invoice = URL::to($filePath);

            return redirect($invoice);
        } else {
            return response()->download($filePath, $filename);
        }
    }

    // For SalesPart Pdf (Created by Mukesh)
    public function salespartpdf($id, Request $request)
    {
        // dd('called');
        $invioces = Invoice::where('id', '=', $id)->first();
        $sales_service_id = $invioces->sales_service_id;
        $invoice_number = $invioces->invoice_number;
        if (! empty($sales_service_id)) {
            $id1 = $sales_service_id;
            $invoice_number = $invoice_number;
        } else {
            $id = $serviceid;
            $auto_id = $invoice->id;
        }

        $viewid = $id;
        $salespart = SalePart::where('id', '=', $id1)->first();
        $productId = $salespart->product_id;
        $products_data = Product::where('id', '=', $productId)->first();
        if ($sales_service_id) {
            $invioce = Invoice::where([['sales_service_id', $id1], ['invoice_number', $invoice_number]])->first();
        } else {
            $invioce = Invoice::where('id', $id)->first();
        }
        if (! empty($invioce->tax_name)) {
            $taxes = explode(', ', $invioce->tax_name);
        } else {
            $taxes = '';
        }

        $logo = Setting::first();

        // Custom Field  Data
        $tbl_custom_fields_salepart = DB::table('tbl_custom_fields')->where([['form_name', '=', 'salepart'], ['always_visable', '=', 'yes']])->get()->toArray();

        // Custom Field Data of User Table (For Customer Module)
        $tbl_custom_fields_customers = DB::table('tbl_custom_fields')->where([['form_name', '=', 'customer'], ['always_visable', '=', 'yes'], ['soft_delete', '=', 0]])->get()->toArray();

        $mpdf = new Mpdf;

        $sales = SalePart::where('id', '=', $id)->first();
        // dd($salespart);
        $saless = SalePart::where('bill_no', '=', $salespart->bill_no)->get();
        $salesp = SalePart::select(DB::raw('SUM(total_price) AS total_price,bill_no,quantity,date,product_id,price ,customer_id,id,salesmanname'))->where('bill_no', '=', $salespart->bill_no)->get();
        $salesps = SalePart::select(DB::raw('SUM(total_price) AS total_price,bill_no,quantity,date,product_id,price ,customer_id,id,salesmanname'))->where('bill_no', '=', $salespart->bill_no)->first();

        // Get the HTML content from the view
        $html = view('invoice.sales_partinvoicepdfl', compact('salesp', 'salesps', 'saless', 'viewid', 'products_data', 'salespart', 'logo', 'invioce', 'taxes', 'tbl_custom_fields_salepart', 'tbl_custom_fields_customers'));

        // Write HTML content to the PDF
        $mpdf->autoLangToFont = true;
        $mpdf->autoScriptToLang = true;
        $mpdf->WriteHTML($html);

        $filename = 'INVOICE-'.$invioces->invoice_number.'.pdf';

        $filePath = public_path('pdf/sales/').$filename;

        $mpdf->Output($filePath, Destination::FILE);

        // Check if page_action is set to 'mobile_app'
        if ($request->input('page_action') === 'mobile_app') {
            $filePath = 'public/pdf/sales/'.$filename;
            $invoice = URL::to($filePath);

            return redirect($invoice);
        } else {
            return response()->download($filePath, $filename);
        }
    }

    public function serviceSend($id)
    {
        $tbl_invoices = Invoice::where('id', '=', $id)->first();
        $serviceid = $tbl_invoices->job_card;
        $tbl_services = Service::where('job_no', '=', $serviceid)->first();
        $c_id = $tbl_invoices->customer_id;
        $v_id = $tbl_invoices->vehicle_id;
        $s_id = $tbl_invoices->sales_id;

        $sales = Sale::where('id', '=', $s_id)->first();
        $job = JobcardDetail::where('service_id', '=', $tbl_services->id)->first();
        $s_date = Sale::where('vehicle_id', '=', $v_id)->first();
        $vehical = Vehicle::where('id', '=', $v_id)->first();
        $customer = User::where('id', '=', $c_id)->first();

        $service_pro = DB::table('tbl_service_pros')->where('service_id', '=', $tbl_services->id)
            ->where('type', '=', 0)
            ->where('chargeable', '=', 1)
            ->get()->toArray();

        $service_pro2 = DB::table('tbl_service_pros')->where('service_id', '=', $tbl_services->id)
            ->where('type', '=', 1)->get()->toArray();

        $tbl_service_observation_points = DB::table('tbl_service_observation_points')->where('services_id', '=', $serviceid)->get();
        $branchDatas = Branch::get();
        $service_tax = Invoice::where('job_card', '=', $serviceid)->first();
        if (! empty($service_tax->tax_name)) {
            $service_taxes = explode(', ', $service_tax->tax_name);
        } else {
            $service_taxes = '';
        }

        $discount = '';
        if ($service_tax !== null) {

            $discount = $service_tax->discount;
        }
        $logo = Setting::first();
        $invoice_pdf = Invoice::with('branch')->where('id', $id)->first();
        /* Get Washbay Service charge */
        $washbay_data = Washbay::where('service_id', '=', $tbl_services->id)->first();

        // Custom Field  Data of Invoice Module
        $tbl_custom_fields_invoice = DB::table('tbl_custom_fields')->where([['form_name', '=', 'invoice'], ['always_visable', '=', 'yes']])->get()->toArray();

        // Custom Field  Data of Service Module
        $tbl_custom_fields_service = DB::table('tbl_custom_fields')->where([['form_name', '=', 'service'], ['always_visable', '=', 'yes']])->get()->toArray();

        // Custom Field Data of User Table (For Customer Module)
        $tbl_custom_fields_customers = DB::table('tbl_custom_fields')->where([['form_name', '=', 'customer'], ['always_visable', '=', 'yes'], ['soft_delete', '=', 0]])->get()->toArray();

        $pdf = PDF::loadView('invoice.serviceinvoicepdf', compact('tbl_invoices', 'serviceid', 'tbl_services', 'sales', 'logo', 'invoice_pdf', 'job', 's_date', 'vehical', 'customer', 'service_pro', 'service_pro2', 'tbl_service_observation_points', 'service_tax', 'service_taxes', 'discount', 'washbay_data', 'branchDatas'));
        // dd($pdf);

        $str = '1234567890';
        $str1 = str_shuffle($str);

        $filePath = 'public/pdf/service/'.$str1.'.pdf';
        $pdf->save($filePath);
        $quotation = URL::to($filePath);

        $message = 'Here is the PDF file for your invoice: '.$quotation;
       
        // $message = "Here is the PDF file for your invoice: $quotation";
        $mobile = getMobile($c_id);
        $whatsappURL = 'http://api.whatsapp.com/send?phone='.urlencode($mobile)."&text=$message";

        return redirect($whatsappURL);
    }

    public function salesSend($id)
    {
        $invioces = Invoice::where('id', '=', $id)->first();
        $sales_service_id = $invioces->sales_service_id;
        $invoice_number = $invioces->invoice_number;
        $c_id = $invioces->customer_id;

        if (! empty($sales_service_id)) {
            $id1 = $sales_service_id;
            $invoice_number = $invoice_number;
        } else {
            $id = $serviceid;
            $auto_id = $invoice->id;
        }

        $viewid = $id;
        $sales = Sale::where('id', '=', $id1)->first();
        $v_id = $sales->vehicle_id;
        $vehicale = Vehicle::where('id', '=', $v_id)->first();
        if ($sales_service_id) {
            $invioce = Invoice::where([['sales_service_id', $id1], ['invoice_number', $invoice_number]])->first();
        } else {
            $invioce = Invoice::where('id', $id)->first();
        }
        if (! empty($invioce->tax_name)) {
            $taxes = explode(', ', $invioce->tax_name);
        } else {
            $taxes = '';
        }

        $rto = RtoTax::where('vehicle_id', '=', $v_id)->first();
        $logo = Setting::first();

        // Custom Field Data of Sales Table
        $tbl_custom_fields_sales = DB::table('tbl_custom_fields')->where([['form_name', '=', 'sales'], ['always_visable', '=', 'yes']])->get()->toArray();

        // Custom Field Data of Invoice Table
        $tbl_custom_fields_invoice = DB::table('tbl_custom_fields')->where([['form_name', '=', 'invoice'], ['always_visable', '=', 'yes']])->get()->toArray();

        // Custom Field Data of User Table (For Customer Module)
        $tbl_custom_fields_customers = DB::table('tbl_custom_fields')->where([['form_name', '=', 'customer'], ['always_visable', '=', 'yes'], ['soft_delete', '=', 0]])->get()->toArray();

        $pdf = PDF::loadView('invoice.salesinvoicepdfl', compact('viewid', 'vehicale', 'sales', 'logo', 'invioce', 'taxes', 'rto', 'tbl_custom_fields_sales', 'tbl_custom_fields_invoice', 'tbl_custom_fields_customers'));

        $str = '1234567890';
        $str1 = str_shuffle($str);

        $filePath = 'public/pdf/sales/'.$str1.'.pdf';
        $pdf->save($filePath);
        $quotation = URL::to($filePath);
        $message = "Here is the PDF file for your invoice: $quotation";
        $mobile = getMobile($c_id);
        $whatsappURL = 'https://api.whatsapp.com/send?phone='.urlencode($mobile)."&text=$message";

        return redirect($whatsappURL);
    }

    public function salespartSend($id)
    {
        $invioces = Invoice::where('id', '=', $id)->first();
        $sales_service_id = $invioces->sales_service_id;
        $invoice_number = $invioces->invoice_number;
        $c_id = $invioces->customer_id;
        if (! empty($sales_service_id)) {
            $id1 = $sales_service_id;
            $invoice_number = $invoice_number;
        } else {
            $id = $serviceid;
            $auto_id = $invoice->id;
        }

        $viewid = $id;
        $salespart = SalePart::where('id', '=', $id1)->first();
        $productId = $salespart->product_id;
        $products_data = Product::where('id', '=', $productId)->first();
        // dd($products_data);
        if ($sales_service_id) {
            $invioce = Invoice::where([['sales_service_id', $id1], ['invoice_number', $invoice_number]])->first();
        } else {
            $invioce = Invoice::where('id', $id)->first();
        }
        if (! empty($invioce->tax_name)) {
            $taxes = explode(', ', $invioce->tax_name);
        } else {
            $taxes = '';
        }

        $logo = Setting::first();

        // Custom Field  Data
        $tbl_custom_fields_salepart = DB::table('tbl_custom_fields')->where([['form_name', '=', 'salepart'], ['always_visable', '=', 'yes']])->get()->toArray();

        // Custom Field Data of User Table (For Customer Module)
        $tbl_custom_fields_customers = DB::table('tbl_custom_fields')->where([['form_name', '=', 'customer'], ['always_visable', '=', 'yes']])->get()->toArray();
        $saless = SalePart::where('bill_no', '=', $salespart->bill_no)->get();
        $salesp = SalePart::select(DB::raw('SUM(total_price) AS total_price,bill_no,quantity,date,product_id,price ,customer_id,id,salesmanname'))->where('bill_no', '=', $salespart->bill_no)->get();
        $salesps = SalePart::select(DB::raw('SUM(total_price) AS total_price,bill_no,quantity,date,product_id,price ,customer_id,id,salesmanname'))->where('bill_no', '=', $salespart->bill_no)->first();

        $pdf = PDF::loadView('invoice.sales_partinvoicepdfl', compact('salesp', 'salesps', 'saless', 'viewid', 'products_data', 'salespart', 'logo', 'invioce', 'taxes', 'tbl_custom_fields_salepart', 'tbl_custom_fields_customers'));

        $str = '1234567890';
        $str1 = str_shuffle($str);

        $filePath = 'public/pdf/sales/'.$str1.'.pdf';
        $pdf->save($filePath);
        $quotation = URL::to($filePath);
        $message = "Here is the PDF file for your invoice: $quotation";
        $mobile = getMobile($c_id);
        $whatsappURL = 'https://api.whatsapp.com/send?phone='.urlencode($mobile)."&text=$message";

        return redirect($whatsappURL);
    }
}
